/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CallableId {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName packageName;
    @Nullable
    private final FqName className;
    @NotNull
    private final Name callableName;
    @Nullable
    private final FqName pathToLocal;
    @Deprecated
    @NotNull
    private static final Name LOCAL_NAME = SpecialNames.LOCAL;
    @Deprecated
    @NotNull
    private static final FqName PACKAGE_FQ_NAME_FOR_LOCAL;

    public CallableId(@NotNull FqName packageName2, @Nullable FqName className, @NotNull Name callableName, @Nullable FqName pathToLocal) {
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)callableName, (String)"callableName");
        this.packageName = packageName2;
        this.className = className;
        this.callableName = callableName;
        this.pathToLocal = pathToLocal;
    }

    public /* synthetic */ CallableId(FqName fqName2, FqName fqName3, Name name2, FqName fqName4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            fqName4 = null;
        }
        this(fqName2, fqName3, name2, fqName4);
    }

    @NotNull
    public final FqName getPackageName() {
        return this.packageName;
    }

    @Nullable
    public final FqName getClassName() {
        return this.className;
    }

    @NotNull
    public final Name getCallableName() {
        return this.callableName;
    }

    public CallableId(@NotNull FqName packageName2, @NotNull Name callableName) {
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)callableName, (String)"callableName");
        this(packageName2, null, callableName, null, 8, null);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String string = this.getPackageName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageName.asString()");
        $this$toString_u24lambda_u2d0.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null));
        $this$toString_u24lambda_u2d0.append("/");
        if (this.getClassName() != null) {
            $this$toString_u24lambda_u2d0.append(this.getClassName());
            $this$toString_u24lambda_u2d0.append(".");
        }
        $this$toString_u24lambda_u2d0.append(this.getCallableName());
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public int hashCode() {
        int result2 = this.packageName.hashCode();
        result2 = result2 * 31 + (this.className == null ? 0 : this.className.hashCode());
        result2 = result2 * 31 + this.callableName.hashCode();
        result2 = result2 * 31 + (this.pathToLocal == null ? 0 : this.pathToLocal.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CallableId)) {
            return false;
        }
        CallableId callableId = (CallableId)other;
        if (!Intrinsics.areEqual((Object)this.packageName, (Object)callableId.packageName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.className, (Object)callableId.className)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.callableName, (Object)callableId.callableName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pathToLocal, (Object)callableId.pathToLocal);
    }

    static {
        FqName fqName2 = FqName.topLevel(LOCAL_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"topLevel(LOCAL_NAME)");
        PACKAGE_FQ_NAME_FOR_LOCAL = fqName2;
    }

    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

