"use strict";
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeDriveLetter = normalizeDriveLetter;
exports.isUNC = isUNC;
exports.getFileSystemPath = getFileSystemPath;
exports.normalizePath = normalizePath;
exports.getUri = getUri;
const fs = __importStar(require("fs"));
const vscode_uri_1 = require("vscode-uri");
const Is = __importStar(require("./is"));
/**
 * Special functions to deal with path conversions in the context of ESLint
 */
/**
 * Normalizes the drive letter to upper case which is the default in Node but not in
 * VS Code.
 */
function normalizeDriveLetter(path) {
    if (process.platform !== 'win32' || path.length < 2 || path[1] !== ':') {
        return path;
    }
    return path[0].toUpperCase() + path.substring(1);
}
/**
 * Check if the path follows this pattern: `\\hostname\sharename`.
 *
 * @see https://msdn.microsoft.com/en-us/library/gg465305.aspx
 * @return A boolean indication if the path is a UNC path, on none-windows
 * always false.
 */
function isUNC(path) {
    if (process.platform !== 'win32') {
        // UNC is a windows concept
        return false;
    }
    if (!path || path.length < 5) {
        // at least \\a\b
        return false;
    }
    let code = path.charCodeAt(0);
    if (code !== 92 /* CharCode.Backslash */) {
        return false;
    }
    code = path.charCodeAt(1);
    if (code !== 92 /* CharCode.Backslash */) {
        return false;
    }
    let pos = 2;
    const start = pos;
    for (; pos < path.length; pos++) {
        code = path.charCodeAt(pos);
        if (code === 92 /* CharCode.Backslash */) {
            break;
        }
    }
    if (start === pos) {
        return false;
    }
    code = path.charCodeAt(pos + 1);
    if (isNaN(code) || code === 92 /* CharCode.Backslash */) {
        return false;
    }
    return true;
}
function getFileSystemPath(uri, useRealpaths) {
    let result = uri.fsPath;
    if (process.platform === 'win32' && result.length >= 2 && result[1] === ':') {
        // Node by default uses an upper case drive letter and ESLint uses
        // === to compare paths which results in the equal check failing
        // if the drive letter is lower case in th URI. Ensure upper case.
        result = result[0].toUpperCase() + result.substr(1);
    }
    if (useRealpaths) {
        result = tryRealpath(result);
    }
    else if (process.platform === 'win32' || process.platform === 'darwin') {
        const realpath = tryRealpath(result);
        // Only use the real path if only the casing has changed.
        if (realpath.toLowerCase() === result.toLowerCase()) {
            result = realpath;
        }
    }
    return result;
}
function tryRealpath(path) {
    try {
        return fs.realpathSync.native(path);
    }
    catch (error) {
        // Silently ignore errors from `fs.realpathSync` to handle scenarios where
        // the file being linted is not yet written to disk. This occurs in editors
        // such as Neovim for non-written buffers.
        return path;
    }
}
function normalizePath(path) {
    if (path === undefined) {
        return undefined;
    }
    if (process.platform === 'win32') {
        return path.replace(/\\/g, '/');
    }
    return path;
}
function getUri(documentOrUri) {
    return Is.string(documentOrUri)
        ? vscode_uri_1.URI.parse(documentOrUri)
        : documentOrUri instanceof vscode_uri_1.URI
            ? documentOrUri
            : vscode_uri_1.URI.parse(documentOrUri.uri);
}
//# sourceMappingURL=paths.js.map