/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.keystore;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.opensearch.cli.Terminal;
import org.opensearch.cli.UserException;
import org.opensearch.common.settings.KeyStoreWrapper;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.env.Environment;
import org.opensearch.tools.cli.keystore.KeyStoreAwareCommand;

class CreateKeyStoreCommand
extends KeyStoreAwareCommand {
    private final OptionSpec<Void> passwordOption;

    CreateKeyStoreCommand() {
        super("Creates a new opensearch keystore");
        this.passwordOption = this.parser.acceptsAll(Arrays.asList("p", "password"), "Prompt for password to encrypt the keystore");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        try (SecureString password = options.has(this.passwordOption) ? CreateKeyStoreCommand.readPassword(terminal, true) : new SecureString(new char[0]);){
            Path keystoreFile = KeyStoreWrapper.keystorePath((Path)env.configDir());
            if (Files.exists(keystoreFile, new LinkOption[0]) && !terminal.promptYesNo("An opensearch keystore already exists. Overwrite?", false)) {
                terminal.println("Exiting without creating keystore.");
                return;
            }
            KeyStoreWrapper keystore = KeyStoreWrapper.create();
            keystore.save(env.configDir(), password.getChars());
            terminal.println("Created opensearch keystore in " + String.valueOf(KeyStoreWrapper.keystorePath((Path)env.configDir())));
        }
        catch (SecurityException e) {
            throw new UserException(74, "Error creating the opensearch keystore.");
        }
    }
}

