/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.UserScope;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.GroupFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TableFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WindowsDefenderConfigurator;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.testing.ContributionInfo;

public class StartupPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table pluginsList;
    private Workbench workbench;
    private Map<IScopeContext, Button> windowsDefenderIgnore = Map.of();

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.startup_preference_page_context");
        Composite composite = (Composite)((CompositeFactory)((CompositeFactory)((CompositeFactory)CompositeFactory.newComposite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create())).layoutData((Object)new GridData(4, 4, true, true))).font(parent.getFont())).create((Widget)parent);
        this.createExtraContent(composite);
        if (composite.getChildren().length > 0) {
            new Label(composite, 0);
        }
        this.createEarlyStartupSelection(composite);
        return composite;
    }

    protected void createExtraContent(Composite composite) {
        if (Platform.OS.isWindows()) {
            new Label(composite, 0);
            GridDataFactory grapHorizontalSpace = GridDataFactory.swtDefaults().align(4, 1).grab(true, false);
            Group group = (Group)((GroupFactory)GroupFactory.newGroup((int)32).text(WorkbenchMessages.WindowsDefenderConfigurator_statusCheck).layoutData((Object)grapHorizontalSpace.create())).create((Widget)composite);
            GridLayoutFactory.swtDefaults().spacing(5, 7).applyTo((Composite)group);
            String infoText = WindowsDefenderConfigurator.bindProductName(WorkbenchMessages.WindowsDefenderConfigurator_exclusionInformation);
            ((LabelFactory)LabelFactory.newLabel((int)64).text(infoText).layoutData((Object)grapHorizontalSpace.create())).create((Widget)group);
            Button ignoreAllInstall = StartupPreferencePage.createCheckBox(WorkbenchMessages.WindowsDefenderConfigurator_ignoreAllChoice, false, (Composite)group);
            this.windowsDefenderIgnore = Map.of(UserScope.INSTANCE, ignoreAllInstall);
            ((ButtonFactory)ButtonFactory.newButton((int)8).text(WorkbenchMessages.WindowsDefenderConfigurator_runExclusionFromPreferenceButtonLabel).font(composite.getFont())).onSelect(e -> {
                Shell shell = this.getShell();
                try {
                    Boolean excluded = WindowsDefenderConfigurator.runCheckEnforced(null);
                    if (excluded == Boolean.FALSE) {
                        MessageDialog.open((int)2, (Shell)shell, (String)WorkbenchMessages.WindowsDefenderConfigurator_statusCheck, (String)WorkbenchMessages.WindowsDefenderConfigurator_statusInactive, (int)0);
                    }
                }
                catch (CoreException ex) {
                    ErrorDialog.openError((Shell)shell, (String)"Windows Defender exclusion check failed", (String)"An unexpected error occurred while running the Windows Defender exclusion check.", (IStatus)ex.getStatus());
                    WorkbenchPlugin.log("Error while running the Windows Defender exclusion check", ex);
                }
            }).create((Widget)group);
            ((LabelFactory)LabelFactory.newLabel((int)64).text(WorkbenchMessages.WindowsDefenderConfigurator_scriptHint).layoutData((Object)grapHorizontalSpace.create())).create((Widget)group);
            Button showScriptButton = (Button)WidgetFactory.button((int)8).create((Widget)group);
            Text scriptText = (Text)((TextFactory)WidgetFactory.text((int)2312).text(WindowsDefenderConfigurator.createAddExclusionsPowershellCommand(" `\n ")).layoutData((Object)grapHorizontalSpace.create())).create((Widget)group);
            this.setScriptBlockVisible(scriptText, showScriptButton, false);
            showScriptButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setScriptBlockVisible(scriptText, showScriptButton, !scriptText.getVisible())));
            this.updateWindowsDefenderHandlingOptions();
        }
    }

    private void setScriptBlockVisible(Text text, Button button, boolean visible) {
        button.setText(!visible ? WorkbenchMessages.WindowsDefenderConfigurator_scriptShowLabel : WorkbenchMessages.WindowsDefenderConfigurator_scriptHideLabel);
        text.setVisible(visible);
        ((GridData)text.getLayoutData()).exclude = !visible;
        text.requestLayout();
    }

    protected static Button createCheckBox(String text, boolean checked, Composite composite) {
        Button button = (Button)((ButtonFactory)ButtonFactory.newButton((int)32).text(text).font(composite.getFont())).create((Widget)composite);
        button.setSelection(checked);
        return button;
    }

    protected void createEarlyStartupSelection(Composite parent) {
        ((LabelFactory)((LabelFactory)LabelFactory.newLabel((int)0).text(WorkbenchMessages.StartupPreferencePage_label).layoutData((Object)new GridData(4, 0x1000000, true, false))).font(parent.getFont())).create((Widget)parent);
        this.pluginsList = (Table)((TableFactory)((TableFactory)TableFactory.newTable((int)2848).layoutData((Object)new GridData(4, 4, true, true))).font(parent.getFont())).create((Widget)parent);
        TableViewer viewer = new TableViewer(this.pluginsList);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)Platform.getBundle((String)((ContributionInfo)element).getBundleId()).getHeaders().get("Bundle-Name");
            }
        });
        viewer.setComparator(new ViewerComparator());
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setInput((Object)this.workbench.getEarlyActivatedPlugins());
        this.updateCheckState();
    }

    private void updateCheckState() {
        HashSet<String> disabledPlugins = new HashSet<String>(Arrays.asList(this.workbench.getDisabledEarlyActivatedPlugins()));
        int i = 0;
        while (i < this.pluginsList.getItemCount()) {
            TableItem item;
            String pluginId = ((ContributionInfo)(item = this.pluginsList.getItem(i)).getData()).getBundleId();
            item.setChecked(!disabledPlugins.contains(pluginId));
            ++i;
        }
    }

    private void updateWindowsDefenderHandlingOptions() {
        this.windowsDefenderIgnore.forEach((scope, button) -> {
            IEclipsePreferences node = WindowsDefenderConfigurator.getPreference(scope);
            boolean ignore = node.getBoolean("windows.defender.startup.check.skip", false);
            button.setSelection(ignore);
        });
    }

    @Override
    public void init(IWorkbench workbench) {
        this.workbench = (Workbench)workbench;
    }

    protected void performDefaults() {
        IPreferenceStore store = PrefUtil.getInternalPreferenceStore();
        store.setToDefault("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
        this.updateCheckState();
        this.windowsDefenderIgnore.values().forEach(b -> b.setSelection(false));
        this.updateWindowsDefenderHandlingOptions();
    }

    public boolean performOk() {
        TableItem[] items;
        StringBuilder preference = new StringBuilder();
        TableItem[] tableItemArray = items = this.pluginsList.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (!item.getChecked()) {
                preference.append(((ContributionInfo)item.getData()).getBundleId());
                preference.append(';');
            }
            ++n2;
        }
        String pref = preference.toString();
        IPreferenceStore store = PrefUtil.getInternalPreferenceStore();
        store.setValue("PLUGINS_NOT_ACTIVATED_ON_STARTUP", pref);
        PrefUtil.savePrefs();
        this.windowsDefenderIgnore.forEach((scope, button) -> {
            try {
                String skip = button.getSelection() ? Boolean.TRUE.toString() : null;
                WindowsDefenderConfigurator.savePreference(scope, "windows.defender.startup.check.skip", skip);
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Failed to save Windows Defender exclusion check preferences", e);
            }
        });
        return true;
    }
}

