/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.propertylist;

import ghidra.app.merge.MergeResolver;
import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.propertylist.ConflictInfo;
import ghidra.app.merge.propertylist.PropertyListMergePanel;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class PropertyListMergeManager
implements MergeResolver {
    static final int CANCELED = -2;
    static final int ASK_USER = -1;
    static final int LATEST_VERSION = 1;
    static final int MY_VERSION = 2;
    static final int ORIGINAL_VERSION = 3;
    private static String[] PROPERTY_LIST_PHASE = new String[]{"Property List"};
    private int conflictOption;
    private Program resultProgram;
    private Program myProgram;
    private Program originalProgram;
    private Program latestProgram;
    private TaskMonitor currentMonitor;
    private HashMap<String, ArrayList<ConflictInfo>> conflictMap;
    private PropertyListMergePanel mergePanel;
    private int currentConflict;
    private int totalConflictCount;
    private ProgramMultiUserMergeManager mergeManager;
    private int propertyListChoice = -1;

    public PropertyListMergeManager(ProgramMultiUserMergeManager mergeManager, Program resultProgram, Program myProgram, Program originalProgram, Program latestProgram) {
        this.mergeManager = mergeManager;
        this.resultProgram = resultProgram;
        this.myProgram = myProgram;
        this.originalProgram = originalProgram;
        this.latestProgram = latestProgram;
        this.conflictMap = new HashMap();
        this.conflictOption = -1;
    }

    @Override
    public void apply() {
        this.conflictOption = this.mergePanel.getSelectedOption();
        if (this.mergePanel.getUseForAll()) {
            this.propertyListChoice = this.conflictOption;
        }
    }

    @Override
    public void cancel() {
        this.conflictOption = -2;
    }

    @Override
    public String getDescription() {
        return "Merge Property Lists";
    }

    @Override
    public String getName() {
        return "Property List Merger";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(TaskMonitor monitor) {
        this.mergeManager.setInProgress(PROPERTY_LIST_PHASE);
        this.currentMonitor = monitor;
        this.currentConflict = 0;
        this.totalConflictCount = 0;
        List myNames = this.myProgram.getOptionsNames();
        List latestNames = this.latestProgram.getOptionsNames();
        List origNames = this.originalProgram.getOptionsNames();
        int myNamesCount = myNames.size();
        this.mergeManager.updateProgress(0, "Merging Property Lists...");
        int transactionID = this.resultProgram.startTransaction("Merge Property Lists");
        boolean commit = false;
        try {
            this.currentMonitor.initialize((long)myNamesCount);
            for (int i = 0; i < myNamesCount; ++i) {
                if (monitor.isCancelled()) {
                    return;
                }
                this.currentMonitor.setProgress((long)i);
                String myName = (String)myNames.get(i);
                int progress = (int)((float)(i / myNamesCount) * 100.0f);
                this.mergeManager.updateProgress(progress, "Merging property list for " + myName + "...");
                boolean isInLatest = latestNames.contains(myName);
                boolean isInOrig = origNames.contains(myName);
                if (!isInLatest && !isInOrig) {
                    this.addPropertyList(myName);
                    continue;
                }
                if (!isInLatest) continue;
                this.checkValues(myName);
            }
            this.mergeManager.updateProgress(100);
            try {
                this.processConflicts();
                commit = true;
            }
            catch (CancelledException e) {
                commit = false;
            }
        }
        finally {
            this.resultProgram.endTransaction(transactionID, commit);
        }
        this.mergeManager.setCompleted(PROPERTY_LIST_PHASE);
        this.currentMonitor.initialize(0L);
    }

    void setConflictResolution(int option) {
        this.conflictOption = option;
    }

    private void addPropertyList(String listName) {
        Options list = this.myProgram.getOptions(listName);
        Options resultList = this.resultProgram.getOptions(listName);
        for (String optionName : list.getOptionNames()) {
            if (this.currentMonitor.isCancelled()) {
                return;
            }
            this.addProperty(list, resultList, optionName);
        }
    }

    private void addProperty(Options myList, Options resultList, String propertyName) {
        Object value = myList.getObject(propertyName, null);
        if (value != null) {
            resultList.putObject(propertyName, value);
        }
    }

    private void checkValues(String listName) {
        Options myList = this.myProgram.getOptions(listName);
        Options resultList = this.resultProgram.getOptions(listName);
        Options origList = this.originalProgram.getOptions(listName);
        List myNameList = myList.getOptionNames();
        List resultNameList = resultList.getOptionNames();
        for (int i = 0; i < myNameList.size(); ++i) {
            String name = (String)myNameList.get(i);
            if (resultNameList.contains(name)) {
                this.updateValue(myList, resultList, origList, name);
                continue;
            }
            this.checkForAddedProperty(myList, resultList, origList, name);
        }
        this.checkDeletedProperties(resultList, origList, myNameList, resultNameList, origList.getOptionNames());
    }

    private void checkDeletedProperties(Options latestList, Options origList, List<String> myNames, List<String> latestNames, List<String> origNames) {
        for (int i = 0; i < latestNames.size(); ++i) {
            String propertyName = latestNames.get(i);
            if (myNames.contains(propertyName) || !origNames.contains(propertyName)) continue;
            try {
                Object latestValue = this.getValue(latestList, propertyName);
                Object origValue = this.getValue(origList, propertyName);
                if (latestValue.equals(origValue)) {
                    latestList.removeOption(propertyName);
                    continue;
                }
                String listName = latestList.getName();
                ArrayList<ConflictInfo> mapList = this.getConflictList(listName);
                mapList.add(new ConflictInfo(listName, propertyName, latestList.getType(propertyName), OptionType.NO_TYPE, origList.getType(propertyName), latestValue, null, origValue));
                ++this.totalConflictCount;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void updateValue(Options myList, Options resultList, Options origList, String propertyName) {
        Object myValue = this.getValue(myList, propertyName);
        Object resultValue = this.getValue(resultList, propertyName);
        Object origValue = this.getValue(origList, propertyName);
        if (SystemUtilities.isEqual((Object)origValue, (Object)myValue) || SystemUtilities.isEqual((Object)resultValue, (Object)myValue)) {
            return;
        }
        if (SystemUtilities.isEqual((Object)resultValue, (Object)origValue)) {
            this.setValue(resultList, propertyName, myList.getType(propertyName), myValue);
        } else {
            String listName = resultList.getName();
            ArrayList<ConflictInfo> mapList = this.getConflictList(listName);
            mapList.add(new ConflictInfo(listName, propertyName, resultList.getType(propertyName), myList.getType(propertyName), origList.getType(propertyName), resultValue, myValue, origValue));
            ++this.totalConflictCount;
        }
    }

    private ArrayList<ConflictInfo> getConflictList(String listName) {
        ArrayList<ConflictInfo> list = this.conflictMap.get(listName);
        if (list == null) {
            list = new ArrayList();
            this.conflictMap.put(listName, list);
        }
        return list;
    }

    private void checkForAddedProperty(Options myList, Options resultList, Options origList, String propertyName) {
        Object origValue;
        Object myValue = this.getValue(myList, propertyName);
        if (!myValue.equals(origValue = this.getValue(origList, propertyName))) {
            this.setValue(resultList, propertyName, myList.getType(propertyName), myValue);
        }
    }

    private void setValue(Options options, String propertyName, OptionType type, Object value) {
        switch (type) {
            case BOOLEAN_TYPE: {
                options.setBoolean(propertyName, ((Boolean)value).booleanValue());
                break;
            }
            case DOUBLE_TYPE: {
                options.setDouble(propertyName, ((Double)value).doubleValue());
                break;
            }
            case INT_TYPE: {
                options.setInt(propertyName, ((Integer)value).intValue());
                break;
            }
            case LONG_TYPE: {
                options.setLong(propertyName, ((Long)value).longValue());
                break;
            }
            case STRING_TYPE: {
                options.setString(propertyName, (String)value);
                break;
            }
            case DATE_TYPE: {
                options.setDate(propertyName, (Date)value);
                break;
            }
        }
    }

    private Object getValue(Options options, String propertyName) {
        OptionType type = options.getType(propertyName);
        switch (type) {
            case BOOLEAN_TYPE: {
                return options.getBoolean(propertyName, false) ? Boolean.TRUE : Boolean.FALSE;
            }
            case DOUBLE_TYPE: {
                return options.getDouble(propertyName, 0.0);
            }
            case INT_TYPE: {
                return options.getInt(propertyName, 0);
            }
            case LONG_TYPE: {
                return options.getLong(propertyName, 0L);
            }
            case NO_TYPE: {
                return null;
            }
            case STRING_TYPE: {
                return options.getString(propertyName, (String)null);
            }
            case DATE_TYPE: {
                return options.getDate(propertyName, (Date)null);
            }
        }
        return null;
    }

    private void processConflicts() throws CancelledException {
        Object[] listNames = new String[this.conflictMap.size()];
        Iterator<String> iter = this.conflictMap.keySet().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            listNames[idx] = iter.next();
            ++idx;
        }
        Arrays.sort(listNames);
        this.currentMonitor.initialize((long)this.totalConflictCount);
        for (int listNameIndex = 0; listNameIndex < listNames.length; ++listNameIndex) {
            if (this.currentMonitor.isCancelled()) {
                return;
            }
            Object currentListName = listNames[listNameIndex];
            ArrayList<ConflictInfo> list = this.conflictMap.get(currentListName);
            this.processConflictList(list, listNameIndex, (String)currentListName);
        }
    }

    private void processConflictList(ArrayList<ConflictInfo> conflictList, int listNameIndex, String currentListName) throws CancelledException {
        for (int i = 0; i < conflictList.size(); ++i) {
            this.currentMonitor.setProgress((long)i);
            ConflictInfo info = conflictList.get(i);
            ++this.currentConflict;
            if (this.propertyListChoice != -1) {
                this.conflictOption = this.propertyListChoice;
            } else if (this.mergeManager != null && this.conflictOption == -1) {
                this.showMergePanel(info, this.currentConflict, this.totalConflictCount);
            }
            switch (this.conflictOption) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    Options options = this.resultProgram.getOptions(info.getListName());
                    options.removeOption(info.getPropertyName());
                    if (this.conflictOption == 2) {
                        Object myValue = info.getMyValue();
                        if (myValue == null) break;
                        this.setValue(options, info.getPropertyName(), info.getMyType(), info.getMyValue());
                        break;
                    }
                    Object origValue = info.getOrigValue();
                    if (origValue == null) break;
                    this.setValue(options, info.getPropertyName(), info.getOrigType(), info.getOrigValue());
                    break;
                }
                case -2: {
                    throw new CancelledException();
                }
            }
            this.conflictOption = -1;
        }
    }

    private void showMergePanel(final ConflictInfo info, final int conflictIndex, final int totalNumConflicts) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (PropertyListMergeManager.this.mergePanel == null) {
                        PropertyListMergeManager.this.mergePanel = new PropertyListMergePanel(PropertyListMergeManager.this.mergeManager, totalNumConflicts);
                    }
                    PropertyListMergeManager.this.mergePanel.setConflictInfo(conflictIndex, info);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        this.mergeManager.setApplyEnabled(false);
        this.mergeManager.showComponent(this.mergePanel, "PropertyListMerge", new HelpLocation("Repository", "PropertyListConflict"));
    }

    @Override
    public String[][] getPhases() {
        return new String[][]{PROPERTY_LIST_PHASE};
    }
}

