/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.label;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.label.LabelMgrPlugin;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import javax.swing.KeyStroke;

class EditLabelAction
extends ListingContextAction {
    private LabelMgrPlugin plugin;
    static final String EDIT_LABEL = "Edit Label...";
    static final String EDIT_FIELDNAME = "Edit Field Name...";
    private static final String[] POPUP_PATH = new String[]{"Edit Label..."};
    private static final KeyStroke KEYBINDING = KeyStroke.getKeyStroke(76, 0);

    EditLabelAction(LabelMgrPlugin plugin) {
        super("Edit Label", plugin.getName());
        this.setPopupMenuData(new MenuData(POPUP_PATH, null, "Label"));
        this.setKeyBindingData(new KeyBindingData(KEYBINDING));
        this.plugin = plugin;
        this.setEnabled(true);
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        ProgramLocation location;
        if (LabelMgrPlugin.getComponent(context) != null) {
            this.getPopupMenuData().setMenuItemName(EDIT_FIELDNAME);
            return true;
        }
        Symbol symbol = this.plugin.getSymbol(context);
        if (symbol == null) {
            return false;
        }
        if (symbol.isExternal()) {
            return false;
        }
        if (symbol.getSymbolType() == SymbolType.FUNCTION && (location = context.getLocation()) instanceof OperandFieldLocation) {
            return false;
        }
        this.getPopupMenuData().setMenuItemName(EDIT_LABEL);
        return true;
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.editLabelCallback(context);
    }
}

