/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.mz;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.Writeable;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class OldDOSHeader
implements StructConverter,
Writeable {
    public static final String NAME = "OLD_IMAGE_DOS_HEADER";
    public static final int IMAGE_DOS_SIGNATURE = 23117;
    private short e_magic;
    private short e_cblp;
    private short e_cp;
    private short e_crlc;
    private short e_cparhdr;
    private short e_minalloc;
    private short e_maxalloc;
    private short e_ss;
    private short e_sp;
    private short e_csum;
    private short e_ip;
    private short e_cs;
    private short e_lfarlc;
    private short e_ovno;
    protected BinaryReader reader;

    public OldDOSHeader(BinaryReader reader) throws IOException {
        this.reader = reader;
        this.parse();
    }

    public String getProcessorName() {
        return "x86";
    }

    public short e_magic() {
        return this.e_magic;
    }

    public short e_cblp() {
        return this.e_cblp;
    }

    public short e_cp() {
        return this.e_cp;
    }

    public short e_crlc() {
        return this.e_crlc;
    }

    public short e_cparhdr() {
        return this.e_cparhdr;
    }

    public short e_minalloc() {
        return this.e_minalloc;
    }

    public short e_maxalloc() {
        return this.e_maxalloc;
    }

    public short e_ss() {
        return this.e_ss;
    }

    public short e_sp() {
        return this.e_sp;
    }

    public short e_csum() {
        return this.e_csum;
    }

    public short e_ip() {
        return this.e_ip;
    }

    public short e_cs() {
        return this.e_cs;
    }

    public short e_lfarlc() {
        return this.e_lfarlc;
    }

    public short e_ovno() {
        return this.e_ovno;
    }

    public boolean hasNewExeHeader() {
        return false;
    }

    public boolean hasPeHeader() {
        return false;
    }

    public boolean isDosSignature() {
        return this.e_magic == 23117;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(this.getName(), 0);
        struct.add((DataType)new ArrayDataType(ASCII, 2, 1));
        for (int i = 1; i <= 13; ++i) {
            struct.add(WORD);
        }
        struct.getComponent(0).setFieldName("e_magic");
        struct.getComponent(1).setFieldName("e_cblp");
        struct.getComponent(2).setFieldName("e_cp");
        struct.getComponent(3).setFieldName("e_crlc");
        struct.getComponent(4).setFieldName("e_cparhdr");
        struct.getComponent(5).setFieldName("e_minalloc");
        struct.getComponent(6).setFieldName("e_maxalloc");
        struct.getComponent(7).setFieldName("e_ss");
        struct.getComponent(8).setFieldName("e_sp");
        struct.getComponent(9).setFieldName("e_csum");
        struct.getComponent(10).setFieldName("e_ip");
        struct.getComponent(11).setFieldName("e_cs");
        struct.getComponent(12).setFieldName("e_lfarlc");
        struct.getComponent(13).setFieldName("e_ovno");
        struct.getComponent(0).setComment("Magic number");
        struct.getComponent(1).setComment("Bytes of last page");
        struct.getComponent(2).setComment("Pages in file");
        struct.getComponent(3).setComment("Relocations");
        struct.getComponent(4).setComment("Size of header in paragraphs");
        struct.getComponent(5).setComment("Minimum extra paragraphs needed");
        struct.getComponent(6).setComment("Maximum extra paragraphs needed");
        struct.getComponent(7).setComment("Initial (relative) SS value");
        struct.getComponent(8).setComment("Initial SP value");
        struct.getComponent(9).setComment("Checksum");
        struct.getComponent(10).setComment("Initial IP value");
        struct.getComponent(11).setComment("Initial (relative) CS value");
        struct.getComponent(12).setComment("File address of relocation table");
        struct.getComponent(13).setComment("Overlay number");
        struct.setCategoryPath(new CategoryPath("/DOS"));
        return struct;
    }

    protected String getName() {
        return NAME;
    }

    protected void parse() throws IOException {
        this.reader.setPointerIndex(0);
        this.e_magic = this.reader.readNextShort();
        if (!this.isDosSignature()) {
            return;
        }
        this.e_cblp = this.reader.readNextShort();
        this.e_cp = this.reader.readNextShort();
        this.e_crlc = this.reader.readNextShort();
        this.e_cparhdr = this.reader.readNextShort();
        this.e_minalloc = this.reader.readNextShort();
        this.e_maxalloc = this.reader.readNextShort();
        this.e_ss = this.reader.readNextShort();
        this.e_sp = this.reader.readNextShort();
        this.e_csum = this.reader.readNextShort();
        this.e_ip = this.reader.readNextShort();
        this.e_cs = this.reader.readNextShort();
        this.e_lfarlc = this.reader.readNextShort();
        this.e_ovno = this.reader.readNextShort();
    }

    @Override
    public void write(RandomAccessFile raf, DataConverter dc) throws IOException {
        raf.write(dc.getBytes(this.e_magic));
        raf.write(dc.getBytes(this.e_cblp));
        raf.write(dc.getBytes(this.e_cp));
        raf.write(dc.getBytes(this.e_crlc));
        raf.write(dc.getBytes(this.e_cparhdr));
        raf.write(dc.getBytes(this.e_minalloc));
        raf.write(dc.getBytes(this.e_maxalloc));
        raf.write(dc.getBytes(this.e_ss));
        raf.write(dc.getBytes(this.e_sp));
        raf.write(dc.getBytes(this.e_csum));
        raf.write(dc.getBytes(this.e_ip));
        raf.write(dc.getBytes(this.e_cs));
        raf.write(dc.getBytes(this.e_lfarlc));
        raf.write(dc.getBytes(this.e_ovno));
    }
}

