/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_MessageReference
implements StructConverter {
    public static final String NAME = "message_ref";
    private ObjectiveC2_State _state;
    private long implementation;
    private String selector;

    public static int SIZEOF(ObjectiveC2_State state) {
        return 2 * state.pointerSize;
    }

    public ObjectiveC2_MessageReference(ObjectiveC2_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this.implementation = state.is32bit ? reader.readNextUnsignedInt() : reader.readNextLong();
        long selectorIndex = ObjectiveC1_Utilities.readNextIndex(reader, state.is32bit);
        if (selectorIndex != 0L) {
            this.selector = reader.readAsciiString(selectorIndex);
        }
    }

    public long getImplementation() {
        return this.implementation;
    }

    public String getSelector() {
        return this.selector;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add((DataType)new PointerDataType(VOID), this._state.pointerSize, "imp", null);
        struct.add((DataType)new PointerDataType(ASCII), this._state.pointerSize, "sel", null);
        return struct;
    }
}

