/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.codecompare.model;

import ghidra.features.base.codecompare.model.AbstractFunctionComparisonModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Duo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MatchedFunctionComparisonModel
extends AbstractFunctionComparisonModel {
    private Map<Function, Set<Function>> sourceToTargetsMap = new HashMap<Function, Set<Function>>();

    @Override
    public void removeFunction(Function function) {
        if (this.doRemoveFunction(function)) {
            this.fixupActiveFunctions();
            this.fireModelDataChanged();
        }
    }

    @Override
    public void removeFunctions(Collection<Function> functions) {
        boolean didRemove = false;
        for (Function function : functions) {
            didRemove |= this.doRemoveFunction(function);
        }
        if (didRemove) {
            this.fixupActiveFunctions();
            this.fireModelDataChanged();
        }
    }

    private boolean doRemoveFunction(Function function) {
        return this.removeFunctionFromTargets(function) || this.removeFunctionFromSources(function);
    }

    private void fixupActiveFunctions() {
        if (this.sourceToTargetsMap.isEmpty()) {
            this.activeFunctions = new Duo();
            return;
        }
        if (!this.containsFunction(Duo.Side.LEFT, (Function)this.activeFunctions.get(Duo.Side.LEFT))) {
            Function newLeft = this.getFunctions(Duo.Side.LEFT).get(0);
            this.activeFunctions = this.activeFunctions.with(Duo.Side.LEFT, (Object)newLeft);
        }
        if (!this.containsFunction(Duo.Side.RIGHT, (Function)this.activeFunctions.get(Duo.Side.RIGHT))) {
            Function newRight = this.getFunctions(Duo.Side.RIGHT).get(0);
            this.activeFunctions = this.activeFunctions.with(Duo.Side.RIGHT, (Object)newRight);
        }
    }

    private boolean removeFunctionFromTargets(Function function) {
        boolean didRemove = false;
        Iterator<Function> it = this.sourceToTargetsMap.keySet().iterator();
        while (it.hasNext()) {
            Function source = it.next();
            Set<Function> set = this.sourceToTargetsMap.get(source);
            didRemove |= set.remove(function);
            if (!set.isEmpty()) continue;
            it.remove();
        }
        return didRemove;
    }

    private boolean removeFunctionFromSources(Function function) {
        return this.sourceToTargetsMap.remove(function) != null;
    }

    @Override
    public void removeFunctions(Program program) {
        Set<Function> functionsToRemove = this.findFunctions(program);
        this.removeFunctions(functionsToRemove);
    }

    private Set<Function> findFunctions(Program program) {
        HashSet<Function> functions = new HashSet<Function>();
        for (Map.Entry<Function, Set<Function>> entry : this.sourceToTargetsMap.entrySet()) {
            Function source = entry.getKey();
            Set<Function> targets = entry.getValue();
            if (source.getProgram() == program) {
                functions.add(source);
            }
            for (Function function : targets) {
                if (function.getProgram() != program) continue;
                functions.add(function);
            }
        }
        return functions;
    }

    @Override
    public List<Function> getFunctions(Duo.Side side) {
        if (side == Duo.Side.LEFT) {
            return this.getSourceFunctions();
        }
        return this.getTargetFunctions();
    }

    @Override
    public boolean setActiveFunction(Duo.Side side, Function function) {
        if (side == Duo.Side.RIGHT) {
            return super.setActiveFunction(side, function);
        }
        if (function == this.activeFunctions.get(Duo.Side.LEFT)) {
            return false;
        }
        if (!this.containsFunction(side, function)) {
            return false;
        }
        this.activeFunctions = this.activeFunctions.with(side, (Object)function);
        Function newRightSideFunction = this.getFunctions(Duo.Side.RIGHT).get(0);
        this.activeFunctions = this.activeFunctions.with(Duo.Side.RIGHT, (Object)newRightSideFunction);
        this.fireModelDataChanged();
        return true;
    }

    private List<Function> getTargetFunctions() {
        ArrayList<Function> targets = new ArrayList<Function>();
        Function source = this.getActiveFunction(Duo.Side.LEFT);
        if (source != null) {
            targets.addAll((Collection<Function>)this.sourceToTargetsMap.get(source));
        }
        Collections.sort(targets, FUNCTION_COMPARATOR);
        return targets;
    }

    public List<Function> getSourceFunctions() {
        ArrayList<Function> sourceFunctions = new ArrayList<Function>(this.sourceToTargetsMap.keySet());
        Collections.sort(sourceFunctions, FUNCTION_COMPARATOR);
        return sourceFunctions;
    }

    @Override
    public boolean isEmpty() {
        return this.sourceToTargetsMap.isEmpty();
    }

    public void addMatch(Function sourceFunction, Function targetFunction) {
        Set targets = this.sourceToTargetsMap.computeIfAbsent(sourceFunction, k -> new HashSet());
        targets.add(targetFunction);
        this.activeFunctions = new Duo((Object)sourceFunction, (Object)targetFunction);
        this.fireModelDataChanged();
    }

    @Override
    protected boolean containsFunction(Duo.Side side, Function function) {
        if (side == Duo.Side.LEFT) {
            return this.sourceToTargetsMap.containsKey(function);
        }
        return this.sourceToTargetsMap.get(this.activeFunctions.get(Duo.Side.LEFT)).contains(function);
    }
}

