/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.disassemble;

import ghidra.app.plugin.core.assembler.PatchDataAction;
import ghidra.app.plugin.core.debug.disassemble.DebuggerDisassemblerPlugin;
import ghidra.app.services.DebuggerControlService;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TracePatchDataAction
extends PatchDataAction {
    protected final DebuggerDisassemblerPlugin plugin;

    public TracePatchDataAction(DebuggerDisassemblerPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
    }

    protected boolean isApplicableToUnit(CodeUnit cu) {
        return super.isApplicableToUnit(cu) && cu instanceof TraceData;
    }

    protected void applyPatch(AddressRange rng, byte[] encoded) throws MemoryAccessException, CodeUnitInsertionException {
        Program program = this.getProgram();
        if (!(program instanceof TraceProgramView)) {
            return;
        }
        TraceProgramView view = (TraceProgramView)program;
        PatchDataCommand patch = new PatchDataCommand(encoded);
        patch.run(this.tool, (DomainObject)view);
    }

    class PatchDataCommand
    extends BackgroundCommand<TraceProgramView> {
        private final byte[] encoded;

        public PatchDataCommand(byte[] encoded) {
            this.encoded = encoded;
        }

        public boolean applyTo(TraceProgramView view, TaskMonitor monitor) {
            DebuggerControlService controlService = (DebuggerControlService)TracePatchDataAction.this.tool.getService(DebuggerControlService.class);
            if (controlService == null) {
                return true;
            }
            DebuggerControlService.StateEditor editor = controlService.createStateEditor(view);
            Address address = TracePatchDataAction.this.getAddress();
            try {
                editor.setVariable(address, this.encoded).get(1L, TimeUnit.SECONDS);
                return true;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                this.setStatusMsg("Couldn't patch: " + String.valueOf(e));
                Msg.error((Object)((Object)this), (Object)"Couldn't patch", (Throwable)e);
                return false;
            }
        }
    }
}

