/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.ByRegionAutoMapSpec;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.ProgramManager;
import ghidra.debug.api.action.AutoMapSpec;
import ghidra.debug.api.modules.MapProposal;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;

public class ByModuleAutoMapSpec
implements AutoMapSpec {
    public static final String CONFIG_NAME = "1_MAP_BY_MODULE";

    public static ByModuleAutoMapSpec instance() {
        return (ByModuleAutoMapSpec)AutoMapSpec.fromConfigName((String)CONFIG_NAME);
    }

    public String getConfigName() {
        return CONFIG_NAME;
    }

    public String getMenuName() {
        return "Auto-Map by Module";
    }

    public Icon getMenuIcon() {
        return DebuggerResources.ICON_CONFIG;
    }

    public Collection<TraceEvent<?, ?>> getChangeTypes() {
        return List.of(TraceEvents.MODULE_ADDED, TraceEvents.MODULE_CHANGED, TraceEvents.REGION_ADDED, TraceEvents.REGION_CHANGED);
    }

    public boolean objectHasType(TraceObjectValue value) {
        return value.getParent().queryInterface(TraceModule.class) != null || value.getParent().queryInterface(TraceMemoryRegion.class) != null;
    }

    public String getInfoForObjects(Trace trace, long snap) {
        String modPart = trace.getModuleManager().getLoadedModules(snap).stream().map(m -> m.getName(snap) + ":" + String.valueOf(m.getBase(snap))).sorted().collect(Collectors.joining(","));
        String regPart = ByRegionAutoMapSpec.getInfoForRegions(trace, snap);
        return modPart + ";" + regPart;
    }

    public List<Program> programs(ProgramManager programManager) {
        return Arrays.asList(programManager.getAllOpenPrograms());
    }

    public boolean performMapping(DebuggerStaticMappingService mappingService, Trace trace, long snap, List<Program> programs, TaskMonitor monitor) throws CancelledException {
        Map maps = mappingService.proposeModuleMaps(trace.getModuleManager().getLoadedModules(snap), snap, programs);
        Collection entries = MapProposal.flatten(maps.values());
        entries = MapProposal.removeOverlapping((Collection)entries);
        mappingService.addModuleMappings(entries, monitor, false);
        return !entries.isEmpty();
    }
}

