/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.AbstractHierarchicalMinCrossLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.Layered;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.EiglspergerRunnable;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Layering;
import org.jungrapht.visualization.layout.algorithms.sugiyama.SugiyamaRunnable;
import org.jungrapht.visualization.layout.algorithms.util.AfterRunnable;
import org.jungrapht.visualization.layout.algorithms.util.ExecutorConsumer;
import org.jungrapht.visualization.layout.algorithms.util.LayeredRunnable;
import org.jungrapht.visualization.layout.algorithms.util.Threaded;
import org.jungrapht.visualization.layout.algorithms.util.VertexBoundsFunctionConsumer;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.layout.util.PropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalMinCrossLayoutAlgorithm<V, E>
extends AbstractHierarchicalMinCrossLayoutAlgorithm<V, E>
implements LayoutAlgorithm<V>,
VertexBoundsFunctionConsumer<V>,
Layered<V, E>,
AfterRunnable,
ExecutorConsumer,
Threaded {
    private static final Logger log = LoggerFactory.getLogger(HierarchicalMinCrossLayoutAlgorithm.class);
    protected static final String EIGLSPERGER_THRESHOLD = "jungrapht.mincross.eiglspergerThreshold";
    protected int eiglspergerThreshold;
    protected int transposeLimit;

    public static <V, E> Builder<V, E, ?, ?> edgeAwareBuilder() {
        return new Builder();
    }

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public HierarchicalMinCrossLayoutAlgorithm() {
        this(HierarchicalMinCrossLayoutAlgorithm.edgeAwareBuilder());
    }

    private HierarchicalMinCrossLayoutAlgorithm(Builder<V, E, ?, ?> builder) {
        this(builder.vertexBoundsFunction, builder.eiglspergerThreshold, builder.straightenEdges, builder.postStraighten, builder.transpose, builder.transposeLimit, builder.maxLevelCross, builder.maxLevelCrossFunction, builder.expandLayout, builder.layering, builder.threaded, builder.executor, builder.separateComponents, builder.favoredEdgePredicate, builder.after);
    }

    protected HierarchicalMinCrossLayoutAlgorithm(Function<V, Rectangle> vertexShapeFunction, int eiglspergerThreshold, boolean straightenEdges, boolean postStraighten, boolean transpose, int transposeLimit, int maxLevelCross, Function<Graph<V, E>, Integer> maxLevelCrossFunction, boolean expandLayout, Layering layering, boolean threaded, Executor executor, boolean separateComponents, Predicate<E> favoredEdgePredicate, Runnable after) {
        super(vertexShapeFunction, straightenEdges, postStraighten, transpose, maxLevelCross, maxLevelCrossFunction, expandLayout, layering, Layered.noopComparator, threaded, executor, separateComponents, favoredEdgePredicate, after);
        this.eiglspergerThreshold = eiglspergerThreshold;
        this.transposeLimit = transposeLimit;
    }

    @Override
    protected LayeredRunnable<E> getRunnable(int componentCount, LayoutModel<V> componentLayoutModel) {
        Graph graph = componentLayoutModel.getGraph();
        if (graph.vertexSet().size() + graph.edgeSet().size() < this.eiglspergerThreshold) {
            return ((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)((EiglspergerRunnable.Builder)EiglspergerRunnable.builder().layoutModel(componentLayoutModel)).vertexShapeFunction(this.vertexBoundsFunction)).straightenEdges(this.straightenEdges)).postStraighten(this.postStraighten)).transpose(this.transpose)).maxLevelCross(this.maxLevelCross)).layering(this.layering)).multiComponent(componentCount > 1)).build();
        }
        return ((SugiyamaRunnable.Builder)((SugiyamaRunnable.Builder)((SugiyamaRunnable.Builder)((SugiyamaRunnable.Builder)((SugiyamaRunnable.Builder)((SugiyamaRunnable.Builder)((SugiyamaRunnable.Builder)((SugiyamaRunnable.Builder)((SugiyamaRunnable.Builder)SugiyamaRunnable.builder().layoutModel(componentLayoutModel)).vertexShapeFunction(this.vertexBoundsFunction)).straightenEdges(this.straightenEdges)).postStraighten(this.postStraighten)).transpose(this.transpose)).transposeLimit(this.transposeLimit)).maxLevelCross(this.maxLevelCross)).layering(this.layering)).multiComponent(componentCount > 1)).build();
    }

    static {
        PropertyLoader.load();
    }

    public static class Builder<V, E, T extends HierarchicalMinCrossLayoutAlgorithm<V, E>, B extends Builder<V, E, T, B>>
    extends AbstractHierarchicalMinCrossLayoutAlgorithm.Builder<V, E, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        protected int transposeLimit = Integer.getInteger("jungrapht.mincross.transposeLimit", 6);
        protected int eiglspergerThreshold = Integer.getInteger("jungrapht.mincross.eiglspergerThreshold", 500);

        public B eiglspergerThreshold(int eiglspergerThreshold) {
            this.eiglspergerThreshold = eiglspergerThreshold;
            return (B)((Builder)this.self());
        }

        public B transposeLimit(int transposeLimit) {
            this.transposeLimit = transposeLimit;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new HierarchicalMinCrossLayoutAlgorithm(this);
        }
    }
}

