/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Collections;

public class RotatingGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    public RotatingGraphMousePlugin() {
        this(17);
    }

    public RotatingGraphMousePlugin(int modifiers) {
        super(modifiers);
        Dimension cd = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
        BufferedImage cursorImage = new BufferedImage(cd.width, cd.height, 2);
        Graphics2D g = cursorImage.createGraphics();
        g.addRenderingHints(Collections.singletonMap(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, 16, 16);
        int left = 0;
        int top = 0;
        int right = 15;
        int bottom = 15;
        g.setColor(Color.white);
        g.setStroke(new BasicStroke(3.0f));
        g.drawLine(left + 2, top + 6, right / 2 + 1, top);
        g.drawLine(right / 2 + 1, top, right - 2, top + 5);
        g.drawLine(left + 2, bottom - 6, right / 2, bottom);
        g.drawLine(right / 2, bottom, right - 2, bottom - 6);
        g.drawLine(left + 2, top + 6, left + 5, top + 6);
        g.drawLine(left + 2, top + 6, left + 2, top + 3);
        g.drawLine(right - 2, bottom - 6, right - 6, bottom - 6);
        g.drawLine(right - 2, bottom - 6, right - 2, bottom - 3);
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(left + 2, top + 6, right / 2 + 1, top);
        g.drawLine(right / 2 + 1, top, right - 2, top + 5);
        g.drawLine(left + 2, bottom - 6, right / 2, bottom);
        g.drawLine(right / 2, bottom, right - 2, bottom - 6);
        g.drawLine(left + 2, top + 6, left + 5, top + 6);
        g.drawLine(left + 2, top + 6, left + 2, top + 3);
        g.drawLine(right - 2, bottom - 6, right - 6, bottom - 6);
        g.drawLine(right - 2, bottom - 6, right - 2, bottom - 3);
        g.dispose();
        this.cursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(), "RotateCursor");
    }

    @Override
    public void mousePressed(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        this.down = e.getPoint();
        if (accepted) {
            vv.setCursor(this.cursor);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        this.down = null;
        vv.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.down == null) {
            return;
        }
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            MutableTransformer modelTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
            vv.setCursor(this.cursor);
            Point2D center = vv.getCenter();
            Point q = this.down;
            Point p = e.getPoint();
            Point2D.Double v1 = new Point2D.Double(center.getX() - ((Point2D)p).getX(), center.getY() - ((Point2D)p).getY());
            Point2D.Double v2 = new Point2D.Double(center.getX() - ((Point2D)q).getX(), center.getY() - ((Point2D)q).getY());
            double theta = this.angleBetween(v1, v2);
            modelTransformer.rotate(theta, vv.getRenderContext().getMultiLayerTransformer().inverseTransform(Layer.VIEW, center));
            this.down.x = e.getX();
            this.down.y = e.getY();
            e.consume();
        }
    }

    protected double angleBetween(Point2D v1, Point2D v2) {
        double angle;
        double x1 = v1.getX();
        double y1 = v1.getY();
        double x2 = v2.getX();
        double y2 = v2.getY();
        double cross = x1 * y2 - x2 * y1;
        int cw = 1;
        if (cross > 0.0) {
            cw = -1;
        }
        if (Double.isNaN(angle = (double)cw * Math.acos((x1 * x2 + y1 * y2) / (Math.sqrt(x1 * x1 + y1 * y1) * Math.sqrt(x2 * x2 + y2 * y2))))) {
            angle = 0.0;
        }
        return angle;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

