/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.AnnotationSetItem;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.FieldAnnotationsItem;
import ghidra.file.formats.android.dex.format.MethodAnnotationsItem;
import ghidra.file.formats.android.dex.format.ParameterAnnotationsItem;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationsDirectoryItem
implements StructConverter {
    private int classAnnotationsOffset;
    private int fieldsSize;
    private int annotatedMethodsSize;
    private int annotatedParametersSize;
    private List<FieldAnnotationsItem> fieldAnnotations = new ArrayList<FieldAnnotationsItem>();
    private List<MethodAnnotationsItem> methodAnnotations = new ArrayList<MethodAnnotationsItem>();
    private List<ParameterAnnotationsItem> parameterAnnotations = new ArrayList<ParameterAnnotationsItem>();
    private AnnotationSetItem _classAnnotations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationsDirectoryItem(BinaryReader reader, DexHeader dexHeader) throws IOException {
        int i;
        this.classAnnotationsOffset = reader.readNextInt();
        this.fieldsSize = reader.readNextInt();
        this.annotatedMethodsSize = reader.readNextInt();
        this.annotatedParametersSize = reader.readNextInt();
        for (i = 0; i < this.fieldsSize; ++i) {
            this.fieldAnnotations.add(new FieldAnnotationsItem(reader, dexHeader));
        }
        for (i = 0; i < this.annotatedMethodsSize; ++i) {
            this.methodAnnotations.add(new MethodAnnotationsItem(reader, dexHeader));
        }
        if (this.classAnnotationsOffset > 0) {
            long oldIndex = reader.getPointerIndex();
            try {
                reader.setPointerIndex(DexUtil.adjustOffset(this.classAnnotationsOffset, dexHeader));
                this._classAnnotations = new AnnotationSetItem(reader, dexHeader);
            }
            finally {
                reader.setPointerIndex(oldIndex);
            }
        }
    }

    public int getClassAnnotationsOffset() {
        return this.classAnnotationsOffset;
    }

    public int getFieldsSize() {
        return this.fieldsSize;
    }

    public int getAnnotatedMethodsSize() {
        return this.annotatedMethodsSize;
    }

    public int getAnnotatedParametersSize() {
        return this.annotatedParametersSize;
    }

    public List<FieldAnnotationsItem> getFieldAnnotations() {
        return Collections.unmodifiableList(this.fieldAnnotations);
    }

    public List<MethodAnnotationsItem> getMethodAnnotations() {
        return Collections.unmodifiableList(this.methodAnnotations);
    }

    public List<ParameterAnnotationsItem> getParameterAnnotations() {
        return Collections.unmodifiableList(this.parameterAnnotations);
    }

    public AnnotationSetItem getClassAnnotations() {
        return this._classAnnotations;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("annotations_directory_item_" + this.fieldsSize + "_" + this.annotatedMethodsSize + "_" + this.annotatedParametersSize, 0);
        structure.add(DWORD, "class_annotations_off", null);
        structure.add(DWORD, "fields_size", null);
        structure.add(DWORD, "annotated_methods_size", null);
        structure.add(DWORD, "annotated_parameters_size", null);
        int index = 0;
        for (FieldAnnotationsItem field : this.fieldAnnotations) {
            structure.add(field.toDataType(), "field_" + index, null);
            ++index;
        }
        index = 0;
        for (MethodAnnotationsItem method : this.methodAnnotations) {
            structure.add(method.toDataType(), "method_" + index, null);
            ++index;
        }
        index = 0;
        for (ParameterAnnotationsItem parameter : this.parameterAnnotations) {
            structure.add(parameter.toDataType(), "parameter_" + index, null);
            ++index;
        }
        structure.setCategoryPath(new CategoryPath("/dex/annotations_directory_item"));
        return structure;
    }
}

