/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.tlt;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TypeLookupTableEntry
implements StructConverter {
    protected int str_offset_;
    protected int data_;
    protected short next_pos_delta_;

    protected TypeLookupTableEntry() {
    }

    public TypeLookupTableEntry(BinaryReader reader) throws IOException {
        this.str_offset_ = reader.readNextInt();
        this.data_ = Short.toUnsignedInt(reader.readNextShort());
        this.next_pos_delta_ = reader.readNextShort();
    }

    public int getStringOffset() {
        return this.str_offset_;
    }

    public int getData() {
        return this.data_;
    }

    public short getNextPosDelta() {
        return this.next_pos_delta_;
    }

    public boolean isEmpty() {
        return this.str_offset_ == 0;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(TypeLookupTableEntry.class.getSimpleName(), 0);
        structure.add(DWORD, "str_offset_", null);
        structure.add(WORD, "data_", null);
        structure.add(WORD, "next_pos_delta_", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

