/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FullDumpHeader
implements StructConverter {
    public static final String NAME = "PAGEDUMP_FULL";
    public static final int SIGNATURE = 1162297680;
    private int signature;
    private int validDump;
    private long dumpOptions;
    private long headerSize;
    private long bitmapSize;
    private long pages;
    private byte[] buffer;
    private Map<Integer, Integer> pfnToRva = new HashMap<Integer, Integer>();
    private DumpFileReader reader;
    private long index;

    FullDumpHeader(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setSignature(this.reader.readNextInt());
        this.setValidDump(this.reader.readNextInt());
        this.setDumpOptions(this.reader.readNextLong());
        this.reader.readNextLong();
        this.reader.readNextLong();
        this.setHeaderSize(this.reader.readNextLong());
        this.setBitmapSize(this.reader.readNextLong());
        this.setPages(this.reader.readNextLong());
        this.buffer = new byte[(int)(this.pages + 7L) / 8];
        int pfn = 0;
        int rvan = 0;
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = this.reader.readNextByte();
            short temp = (short)(this.buffer[i] + 256);
            for (int j = 0; j < 8; ++j) {
                int bitval = (temp >> j) % 2;
                if (bitval == 0) continue;
                pfn = i * 8 + j;
                this.pfnToRva.put(pfn, rvan++);
            }
        }
    }

    public DataType toDataType() {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(STRING, 4, "Signature", null);
        struct.add(STRING, 4, "ValidDump", null);
        struct.add(QWORD, 8, "DumpOptions", null);
        struct.add(QWORD, 8, "", null);
        struct.add(QWORD, 8, "", null);
        struct.add(QWORD, 8, "HeaderSize", null);
        struct.add(QWORD, 8, "BitmapSize", null);
        struct.add(QWORD, 8, "Pages", null);
        if (this.bitmapSize > 0L) {
            ArrayDataType a = new ArrayDataType(BYTE, (int)(this.pages / 8L), 1);
            struct.add((DataType)a, a.getLength(), "Buffer", null);
        }
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public int getSignature() {
        return this.signature;
    }

    public void setSignature(int signature) {
        this.signature = signature;
    }

    public int getValidDump() {
        return this.validDump;
    }

    public void setValidDump(int validDump) {
        this.validDump = validDump;
    }

    public long getDumpOptions() {
        return this.dumpOptions;
    }

    public void setDumpOptions(long dumpOptions) {
        this.dumpOptions = dumpOptions;
    }

    public long getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(long headerSize) {
        this.headerSize = headerSize;
    }

    public long getBitmapSize() {
        return this.bitmapSize;
    }

    public void setBitmapSize(long bitmapSize) {
        this.bitmapSize = bitmapSize;
    }

    public long getPages() {
        return this.pages;
    }

    public void setPages(long pages) {
        this.pages = pages;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public Integer PFN2RVA(Integer pfn) {
        return this.pfnToRva.get(pfn);
    }

    public Set<Integer> pfnKeySet() {
        return this.pfnToRva.keySet();
    }
}

