/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;

public class EHDataTypeUtilities {
    private EHDataTypeUtilities() {
    }

    public static int getEHStateValue(DataType dataType, int componentOrdinal, MemBuffer memBuffer) {
        return EHDataTypeUtilities.getIntegerValue(dataType, componentOrdinal, memBuffer);
    }

    public static int getCount(DataType dataType, int componentOrdinal, MemBuffer memBuffer) {
        return EHDataTypeUtilities.getIntegerValue(dataType, componentOrdinal, memBuffer);
    }

    public static int getIntegerValue(DataType dataType, int componentOrdinal, MemBuffer memBuffer) {
        Scalar scalar = EHDataTypeUtilities.getScalarValue(dataType, componentOrdinal, memBuffer);
        return (int)scalar.getValue();
    }

    public static Scalar getScalarValue(DataType dataType, int componentOrdinal, MemBuffer memBuffer) {
        DataTypeComponent comp = EHDataTypeUtilities.getComponent(dataType, componentOrdinal, memBuffer);
        if (comp == null) {
            throw new IllegalArgumentException("Couldn't get component " + componentOrdinal + " of " + dataType.getName() + " @ " + String.valueOf(memBuffer.getAddress()) + ".");
        }
        Address compAddress = EHDataTypeUtilities.getComponentAddress(comp, memBuffer);
        DataType compDt = comp.getDataType();
        int length = comp.getLength();
        DumbMemBufferImpl compMemBuffer = new DumbMemBufferImpl(memBuffer.getMemory(), compAddress);
        Object value = compDt.getValue((MemBuffer)compMemBuffer, comp.getDefaultSettings(), length);
        if (value instanceof Scalar) {
            return (Scalar)value;
        }
        throw new IllegalArgumentException("Component " + componentOrdinal + " of " + dataType.getName() + " is a " + compDt.getName() + " data type, which doesn't produce a Scalar value.");
    }

    private static Address getComponentAddress(DataTypeComponent comp, MemBuffer memBuffer) {
        int offset = comp.getOffset();
        Address minAddress = memBuffer.getAddress();
        try {
            return minAddress.add((long)offset);
        }
        catch (AddressOutOfBoundsException e) {
            throw new IllegalArgumentException("Can't get component " + comp.getOrdinal() + " from memory buffer for data type " + comp.getParent().getName() + ".", e);
        }
    }

    private static DataTypeComponent getComponent(DataType dataType, int componentOrdinal, MemBuffer memBuffer) {
        if (dataType == null) {
            throw new IllegalArgumentException("Data type cannot be null.");
        }
        if (dataType instanceof DynamicDataType) {
            DynamicDataType dynamicDt = (DynamicDataType)dataType;
            return dynamicDt.getComponent(componentOrdinal, memBuffer);
        }
        if (dataType instanceof TypeDef) {
            dataType = ((TypeDef)dataType).getBaseDataType();
        }
        if (!(dataType instanceof Structure)) {
            throw new IllegalArgumentException("Data type " + dataType.getName() + " must be a structure or a typedef on a structure.");
        }
        Structure struct = (Structure)dataType;
        return struct.getComponent(componentOrdinal);
    }

    public static Address getAddress(DataType dataType, int componentOrdinal, MemBuffer memBuffer) {
        DataTypeComponent comp = EHDataTypeUtilities.getComponent(dataType, componentOrdinal, memBuffer);
        if (comp == null) {
            throw new IllegalArgumentException("Couldn't get component " + componentOrdinal + " of " + dataType.getName() + " @ " + String.valueOf(memBuffer.getAddress()) + ".");
        }
        Address compAddress = EHDataTypeUtilities.getComponentAddress(comp, memBuffer);
        DataType compDt = comp.getDataType();
        int length = comp.getLength();
        DumbMemBufferImpl compMemBuffer = new DumbMemBufferImpl(memBuffer.getMemory(), compAddress);
        Object value = compDt.getValue((MemBuffer)compMemBuffer, comp.getDefaultSettings(), length);
        if (value == null) {
            return null;
        }
        if (value instanceof Address) {
            return (Address)value;
        }
        throw new IllegalArgumentException("Component " + componentOrdinal + " of " + dataType.getName() + " is a " + compDt.getName() + " data type, which doesn't produce an Address value.");
    }

    public static Address getComponentAddress(DataType dataType, int componentOrdinal, MemBuffer memBuffer) {
        DataTypeComponent comp = EHDataTypeUtilities.getComponent(dataType, componentOrdinal, memBuffer);
        if (comp == null) {
            throw new IllegalArgumentException("Couldn't get component " + componentOrdinal + " of " + dataType.getName() + " @ " + String.valueOf(memBuffer.getAddress()) + ".");
        }
        return EHDataTypeUtilities.getComponentAddress(comp, memBuffer);
    }

    public static String createPlateCommentIfNeeded(Program program, String prefix, String dataTypeName, String suffix, Address address, DataApplyOptions applyOptions) {
        Listing listing = program.getListing();
        String existingComment = listing.getComment(CommentType.PLATE, address);
        if (!applyOptions.shouldCreateComments()) {
            return existingComment;
        }
        if (dataTypeName != null) {
            if (existingComment != null && existingComment.contains(dataTypeName)) {
                return existingComment;
            }
            String appliedPrefix = prefix != null ? prefix : "";
            String appliedSuffix = suffix != null ? suffix : "";
            Object appliedExisting = existingComment != null ? existingComment + "\n" : "";
            String appliedComment = (String)appliedExisting + appliedPrefix + dataTypeName + appliedSuffix;
            listing.setComment(address, CommentType.PLATE, appliedComment);
            return appliedComment;
        }
        return existingComment;
    }

    public static Symbol createSymbolIfNeeded(Program program, Namespace classNamespace, String dataTypeName, Address address, DataApplyOptions applyOptions) throws InvalidInputException {
        if (dataTypeName == null || !applyOptions.shouldCreateLabel()) {
            return null;
        }
        dataTypeName = SymbolUtilities.replaceInvalidChars((String)dataTypeName, (boolean)true);
        SymbolTable symbolTable = program.getSymbolTable();
        SymbolIterator symbols = symbolTable.getSymbolsAsIterator(address);
        for (Symbol symbol : symbols) {
            if (!symbol.getName().contains(dataTypeName) || !symbol.getParentNamespace().equals((Object)classNamespace)) continue;
            return null;
        }
        Symbol symbol = symbolTable.createLabel(address, dataTypeName, classNamespace, SourceType.IMPORTED);
        symbol.setPrimary();
        return symbol;
    }

    public static Symbol createSymbolIfNeeded(Program program, String symbolPrefix, Address symbolAddress) throws InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol primarySymbol = symbolTable.getPrimarySymbol(symbolAddress);
        if (primarySymbol != null && primarySymbol.getSource() != SourceType.DEFAULT) {
            return null;
        }
        String addressAppendedName = SymbolUtilities.getAddressAppendedName((String)symbolPrefix, (Address)symbolAddress);
        return symbolTable.createLabel(symbolAddress, addressAppendedName, SourceType.ANALYSIS);
    }

    public static boolean createFunctionIfNeeded(Program program, Address functionAddress) {
        CreateFunctionCmd cmd;
        DisassembleCommand cmd2;
        Address normalizedFunctionAddress;
        Listing listing = program.getListing();
        Instruction inst = listing.getInstructionAt(normalizedFunctionAddress = PseudoDisassembler.getNormalizedDisassemblyAddress((Program)program, (Address)functionAddress));
        if (inst == null && (!(cmd2 = new DisassembleCommand(functionAddress = PseudoDisassembler.setTargetContextForDisassembly((Program)program, (Address)functionAddress), null, true)).applyTo((DomainObject)program) || cmd2.getDisassembledAddressSet().isEmpty())) {
            Msg.error(EHDataTypeUtilities.class, (Object)("Failed to disassemble at " + String.valueOf(functionAddress)));
            return false;
        }
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionAt(normalizedFunctionAddress);
        if (function == null && !(cmd = new CreateFunctionCmd(normalizedFunctionAddress)).applyTo((DomainObject)program)) {
            Msg.error(EHDataTypeUtilities.class, (Object)("Failed to create function at " + String.valueOf(normalizedFunctionAddress)));
            return false;
        }
        return true;
    }

    public static boolean isValidAddress(Program program, Address address) {
        if (address == null) {
            throw new IllegalArgumentException("address cannot be null.");
        }
        return program.getMemory().getLoadedAndInitializedAddressSet().contains(address);
    }

    public static boolean isValidForFunction(Program program, Address functionAddress) {
        if (functionAddress == null) {
            throw new IllegalArgumentException("functionAddress cannot be null.");
        }
        if (!EHDataTypeUtilities.isValidAddress(program, functionAddress)) {
            return false;
        }
        Listing listing = program.getListing();
        return listing.getInstructionAt(functionAddress) != null || listing.getUndefinedDataAt(functionAddress) != null;
    }
}

