/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.util.Objects;
import java.util.function.Consumer;

public class Duo<T> {
    private final T left;
    private final T right;

    public Duo() {
        this(null, null);
    }

    public Duo(T left, T right) {
        this.left = left;
        this.right = right;
    }

    public T get(Side side) {
        return side == Side.LEFT ? this.left : this.right;
    }

    public Duo<T> with(Side side, T newValue) {
        if (side == Side.LEFT) {
            return new Duo<T>(newValue, this.right);
        }
        return new Duo<T>(this.left, newValue);
    }

    public void each(Consumer<T> c) {
        if (this.left != null) {
            c.accept(this.left);
        }
        if (this.right != null) {
            c.accept(this.right);
        }
    }

    public boolean equals(T otherLeft, T otherRight) {
        return Objects.equals(this.left, otherLeft) && Objects.equals(this.right, otherRight);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Duo other = (Duo)obj;
        return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    public static enum Side {
        LEFT,
        RIGHT;


        public Side otherSide() {
            return this == LEFT ? RIGHT : LEFT;
        }
    }
}

