/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.shape;

import com.google.common.base.Function;
import edu.uci.ics.jung.visualization.RenderContext;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;

public class ArticulatedEdgeTransformer<V extends VisualVertex, E extends VisualEdge<V>>
implements Function<E, Shape> {
    private RenderContext<V, E> renderContext;

    public void setRenderContext(RenderContext<V, E> context) {
        this.renderContext = context;
    }

    public Shape apply(E e) {
        VisualVertex end;
        VisualVertex start = (VisualVertex)e.getStart();
        boolean isLoop = start.equals(end = (VisualVertex)e.getEnd());
        if (isLoop) {
            Function vertexShapeTransformer = this.renderContext.getVertexShapeTransformer();
            Shape vertexShape = ArticulatedEdgeTransformer.getVertexShapeForEdge(end, vertexShapeTransformer);
            Shape hollowEgdeLoop = GraphViewerUtils.createHollowEgdeLoop();
            return GraphViewerUtils.createEgdeLoopInGraphSpace(hollowEgdeLoop, vertexShape, 0.0, 0.0);
        }
        if (isLoop) {
            return GraphViewerUtils.createHollowEgdeLoop();
        }
        Point2D p1 = start.getLocation();
        if (p1 == null) {
            this.logMissingLocation(e, start);
            return null;
        }
        Point2D p2 = end.getLocation();
        if (p2 == null) {
            this.logMissingLocation(e, end);
            return null;
        }
        List<Point2D> articulations = e.getArticulationPoints();
        double originX = p1.getX();
        double originY = p1.getY();
        boolean offset = false;
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        for (Point2D pt : articulations) {
            float x = (float)(pt.getX() - originX) + (float)offset;
            float y = (float)(pt.getY() - originY) + (float)offset;
            path.lineTo(x, y);
            path.moveTo(x, y);
        }
        float p2x = (float)(p2.getX() - originX);
        float p2y = (float)(p2.getY() - originY);
        path.lineTo(p2x, p2y);
        path.moveTo(p2x, p2y);
        path.closePath();
        return path;
    }

    private static <V> Shape getVertexShapeForEdge(V v, Function<? super V, Shape> vertexShaper) {
        if (vertexShaper instanceof VisualGraphVertexShapeTransformer && v instanceof VisualVertex) {
            VisualVertex vv = (VisualVertex)v;
            return ((VisualGraphVertexShapeTransformer)vertexShaper).transformToCompactShape(vv);
        }
        return (Shape)vertexShaper.apply(v);
    }

    private void logMissingLocation(E e, V v) {
        boolean isStart = e.getStart() == v;
        String type = isStart ? "start" : "end";
        Msg.debug((Object)this, (Object)("no location defined for " + type + " vertex: " + String.valueOf(v) + " " + System.identityHashCode(v)));
        if (SystemUtilities.isInTestingMode()) {
            throw new IllegalStateException("Edge vertex is missing a location");
        }
    }
}

