/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.graph.renderer;

import com.google.common.base.Function;
import functioncalls.graph.FcgEdge;
import ghidra.util.ColorUtils;
import java.awt.Color;

public class FcgEdgePaintTransformer
implements Function<FcgEdge, Color> {
    private Color directColor;
    private Color indirectColor;
    private Color[] directColorWithAlpha = new Color[10];

    public FcgEdgePaintTransformer(Color directColor, Color indirectColor) {
        this.directColor = directColor;
        this.indirectColor = indirectColor;
        this.directColorWithAlpha = this.alphatize(directColor);
    }

    private Color[] alphatize(Color c) {
        Color[] alphad = new Color[10];
        alphad[0] = c;
        for (int i = 1; i < 10; ++i) {
            double newAlpha = 255.0 - (double)i * 25.5;
            alphad[i] = ColorUtils.withAlpha((Color)c, (int)((int)newAlpha));
        }
        return alphad;
    }

    public Color apply(FcgEdge e) {
        if (e.isDirectEdge()) {
            return this.getDirectEdgeColor(e);
        }
        return this.indirectColor;
    }

    private Color getDirectEdgeColor(FcgEdge e) {
        return this.directColor;
    }
}

