/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class C13InlineeSourceLine {
    protected long inlinee;
    protected int fileId;
    protected int sourceLineNum;

    static int getBaseRecordSize() {
        return 12;
    }

    C13InlineeSourceLine(PdbByteReader reader) throws PdbException {
        this.inlinee = reader.parseUnsignedIntVal();
        this.fileId = reader.parseInt();
        this.sourceLineNum = reader.parseInt();
    }

    public long getInlinee() {
        return this.inlinee;
    }

    public int getFileId() {
        return this.fileId;
    }

    public long getSourceLineNum() {
        return this.sourceLineNum;
    }

    public String toString() {
        return String.format("0x%09x, 0x%06x, %d", this.inlinee, this.fileId, this.sourceLineNum);
    }
}

