/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.DataTypeNamingUtil;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractArgumentsListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.CallingConvention;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrimitiveMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsDataTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Undefined;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFunctionTypeApplier
extends MsDataTypeApplier {
    public AbstractFunctionTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    protected abstract CallingConvention getCallingConvention(AbstractMsType var1);

    protected abstract Pointer getThisPointer(AbstractMsType var1) throws CancelledException, PdbException;

    protected abstract RecordNumber getThisPointerRecordNumber(AbstractMsType var1);

    protected abstract RecordNumber getContainingComplexRecordNumber(AbstractMsType var1);

    protected abstract void processContainingType(AbstractMsType var1);

    protected boolean isConstructor(AbstractMsType type) {
        return false;
    }

    protected abstract RecordNumber getReturnRecordNumber(AbstractMsType var1);

    protected abstract RecordNumber getArgListRecordNumber(AbstractMsType var1);

    private boolean setReturnType(FunctionDefinitionDataType functionDefinition, AbstractMsType type) throws CancelledException, PdbException {
        Pointer returnType;
        if (this.isConstructor(type)) {
            returnType = this.getThisPointer(type);
        } else {
            RecordNumber returnRecord = this.getReturnRecordNumber(type);
            returnType = this.applicator.getDataType(returnRecord);
            if (returnType == null) {
                return false;
            }
        }
        functionDefinition.setReturnType((DataType)returnType);
        return true;
    }

    private void setCallingConvention(FunctionDefinitionDataType functionDefinition, CallingConvention callingConvention, Pointer thisPointer) {
        String convention;
        if (thisPointer != null) {
            convention = "__thiscall";
        } else {
            switch (callingConvention) {
                case THISCALL: {
                    convention = "__thiscall";
                    break;
                }
                case NEAR_C: {
                    convention = "__cdecl";
                    break;
                }
                case NEAR_VECTOR: {
                    convention = "__vectorcall";
                    break;
                }
                default: {
                    convention = "__cdecl";
                }
            }
        }
        try {
            functionDefinition.setCallingConvention(convention);
        }
        catch (InvalidInputException e) {
            this.applicator.appendLogMsg("Failed to set calling convention `" + convention + "` for " + functionDefinition.getName());
        }
    }

    private boolean setArguments(FunctionDefinitionDataType functionDefinition, AbstractMsType type) throws CancelledException, PdbException {
        List<RecordNumber> args = this.getArgsRecordNumbers(type);
        ArrayList<ParameterDefinitionImpl> parameterDefinitionList = new ArrayList<ParameterDefinitionImpl>();
        int parameterCount = 0;
        for (RecordNumber arg : args) {
            PrimitiveMsType primitive;
            this.applicator.checkCancelled();
            AbstractMsType argMsType = this.applicator.getTypeRecord(arg);
            if (argMsType instanceof PrimitiveMsType && (primitive = (PrimitiveMsType)argMsType).isNoType()) break;
            DataType argDataType = this.applicator.getDataType(arg);
            if (argDataType == null) {
                this.applicator.appendLogMsg("PDB Warning: No type conversion for " + argMsType.toString() + " for parameter " + parameterCount + " of " + functionDefinition.getName());
                continue;
            }
            try {
                ParameterDefinitionImpl parameterDefinition = new ParameterDefinitionImpl(null, argDataType, "");
                parameterDefinitionList.add(parameterDefinition);
                ++parameterCount;
            }
            catch (IllegalArgumentException e) {
                try {
                    DataType substitute = Undefined.getUndefinedDataType((int)argDataType.getLength());
                    ParameterDefinitionImpl parameterDefinition = new ParameterDefinitionImpl(null, substitute, "");
                    parameterDefinitionList.add(parameterDefinition);
                    this.applicator.appendLogMsg("PDB Warning: Could not apply type " + String.valueOf(argDataType) + " for parameter " + ++parameterCount + " of " + functionDefinition.getName() + ". Using undefined type instead.");
                }
                catch (IllegalArgumentException e1) {
                    this.applicator.appendLogMsg("PDB Warning: Could not apply type " + String.valueOf(argDataType) + " for parameter " + parameterCount + " of " + functionDefinition.getName() + ". Undefined failed: " + String.valueOf(e1));
                }
                return false;
            }
        }
        functionDefinition.setArguments(parameterDefinitionList.toArray(new ParameterDefinition[parameterDefinitionList.size()]));
        return true;
    }

    @Override
    boolean apply(AbstractMsType type) throws CancelledException, PdbException {
        if (!this.precheckOrScheduleDependencies(type)) {
            return false;
        }
        FunctionDefinitionDataType functionDefinition = new FunctionDefinitionDataType(this.applicator.getAnonymousFunctionsCategory(), "_func", this.applicator.getDataTypeManager());
        this.processContainingType(type);
        this.setReturnType(functionDefinition, type);
        this.setArguments(functionDefinition, type);
        Pointer thisPointer = this.getThisPointer(type);
        CallingConvention convention = this.getCallingConvention(type);
        this.setCallingConvention(functionDefinition, convention, thisPointer);
        DataTypeNamingUtil.setMangledAnonymousFunctionName((FunctionDefinitionDataType)functionDefinition);
        FunctionDefinitionDataType dataType = functionDefinition;
        this.applicator.putDataType(type, (DataType)dataType);
        return true;
    }

    private boolean precheckOrScheduleDependencies(AbstractMsType type) throws PdbException {
        RecordNumber containerRecordNumber;
        boolean done = true;
        RecordNumber returnRecordNumber = this.getReturnRecordNumber(type);
        DataType dt = this.applicator.getDataTypeOrSchedule(returnRecordNumber);
        if (dt == null) {
            done = false;
        }
        List<RecordNumber> args = this.getArgsRecordNumbers(type);
        for (RecordNumber argRecordNumber : args) {
            dt = this.applicator.getDataTypeOrSchedule(argRecordNumber);
            if (dt != null) continue;
            done = false;
        }
        RecordNumber thisRecordNumber = this.getThisPointerRecordNumber(type);
        if (thisRecordNumber != null && (dt = this.applicator.getDataTypeOrSchedule(thisRecordNumber)) == null) {
            done = false;
        }
        if ((containerRecordNumber = this.getContainingComplexRecordNumber(type)) != null && (dt = this.applicator.getDataTypeOrSchedule(containerRecordNumber)) == null) {
            done = false;
        }
        return done;
    }

    private List<RecordNumber> getArgsRecordNumbers(AbstractMsType type) throws PdbException {
        RecordNumber argsRecord = this.getArgListRecordNumber(type);
        AbstractMsType aType = this.applicator.getTypeRecord(argsRecord);
        if (!(aType instanceof AbstractArgumentsListMsType)) {
            PrimitiveMsType pt;
            if (aType instanceof PrimitiveMsType && (pt = (PrimitiveMsType)aType).isNoType()) {
                return new ArrayList<RecordNumber>();
            }
            throw new PdbException("Expecting arguments list but got: " + aType.getClass().getSimpleName());
        }
        AbstractArgumentsListMsType argsList = (AbstractArgumentsListMsType)aType;
        return argsList.getArgRecordNumbers();
    }
}

