/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsDataTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Map;

public class MultiphaseDataTypeResolver {
    private DefaultPdbApplicator applicator;
    private AbstractPdb pdb;
    private RecordStack todoStack;
    private RecordStack resolveStack;

    public MultiphaseDataTypeResolver(DefaultPdbApplicator applicator) {
        this.applicator = applicator;
        this.pdb = applicator.getPdb();
        this.todoStack = new RecordStack();
        this.resolveStack = new RecordStack();
    }

    void process(RecordNumber recordNumber, TaskMonitor monitor) throws PdbException, CancelledException {
        RecordNumber recordToProcess;
        if (this.applicator.getDataType(recordNumber) != null) {
            return;
        }
        this.scheduleTodo(recordNumber);
        while ((recordToProcess = this.todoStack.peek()) != null) {
            AbstractMsType msType;
            monitor.checkCancelled();
            MsDataTypeApplier dataTypeApplier = (MsDataTypeApplier)this.applicator.getTypeApplier(recordToProcess);
            if (!dataTypeApplier.apply(msType = this.pdb.getTypeRecord(recordToProcess))) continue;
            if (this.todoStack.peek() != recordToProcess) {
                throw new AssertException("Top of stack violation");
            }
            this.todoStack.pop();
            this.resolveStack.push(recordToProcess);
            monitor.incrementProgress(1L);
        }
        while ((recordToProcess = this.resolveStack.pop()) != null) {
            monitor.checkCancelled();
            DataType dataType = this.applicator.getDataType(recordToProcess);
            if (!(dataType instanceof BitFieldDataType)) {
                dataType = this.applicator.resolve(dataType);
                this.applicator.putDataType(recordToProcess, dataType);
            }
            monitor.incrementProgress(1L);
        }
    }

    void scheduleTodo(RecordNumber recordNumber) {
        MsTypeApplier applier = this.applicator.getTypeApplier(recordNumber);
        if (!(applier instanceof MsDataTypeApplier)) {
            return;
        }
        MsDataTypeApplier dataTypeApplier = (MsDataTypeApplier)applier;
        this.todoStack.push(recordNumber);
    }

    static class RecordStack {
        static final int TO_STRING_LIMIT = 500;
        static final RecordNumber HEAD = RecordNumber.typeRecordNumber(-1);
        static final RecordNumber TAIL = RecordNumber.typeRecordNumber(-2);
        Map<RecordNumber, RecordNode> map = new HashMap<RecordNumber, RecordNode>();
        RecordNode head = new RecordNode(HEAD);
        RecordNode tail = new RecordNode(TAIL);
        boolean debug;
        StringBuilder debugBuilder;
        long numNodes;

        RecordStack() {
            this.head.next = null;
            this.head.prev = this.tail;
            this.tail.next = this.head;
            this.tail.prev = null;
            this.numNodes = 0L;
        }

        void setDebug(boolean debug) {
            this.debug = debug;
        }

        boolean contains(RecordNumber recordNumber) {
            return this.map.containsKey(recordNumber);
        }

        void push(RecordNumber recordNumber) {
            RecordNode node = this.getNode(recordNumber);
            if (node == this.head.prev) {
                return;
            }
            if (node == null) {
                node = new RecordNode(recordNumber);
                if (this.debug) {
                    if (this.map.isEmpty()) {
                        this.debugBuilder = new StringBuilder();
                    }
                    this.debugBuilder.append("push:");
                    this.debugBuilder.append(recordNumber);
                    this.debugBuilder.append("\n");
                }
                this.map.put(recordNumber, node);
                ++this.numNodes;
            } else {
                this.removeNodeLinkage(node);
            }
            this.insertNodeLinkage(this.head, node);
        }

        RecordNumber peek() {
            RecordNode node = this.getTop();
            if (node == this.tail) {
                return null;
            }
            return node.recordNumber;
        }

        RecordNumber pop() {
            RecordNode node = this.getTop();
            if (node == this.tail) {
                return null;
            }
            this.removeNodeLinkage(node);
            this.map.remove(node.recordNumber);
            --this.numNodes;
            if (this.debug) {
                this.debugBuilder.append(" pop:");
                this.debugBuilder.append(node.recordNumber);
                this.debugBuilder.append("\n");
                if (this.map.isEmpty()) {
                    System.out.println(this.debugBuilder.toString());
                }
            }
            return node.recordNumber;
        }

        private RecordNode getNode(RecordNumber recordNumber) {
            return this.map.get(recordNumber);
        }

        private RecordNode getTop() {
            return this.head.prev;
        }

        private void insertNodeLinkage(RecordNode locationNode, RecordNode newNode) {
            newNode.next = locationNode;
            newNode.prev = locationNode.prev;
            locationNode.prev.next = newNode;
            locationNode.prev = newNode;
        }

        private void removeNodeLinkage(RecordNode node) {
            node.prev.next = node.next;
            node.next.prev = node.prev;
            node.prev = null;
            node.next = null;
        }

        public String toString() {
            RecordNode node = this.head.prev;
            StringBuilder builder = new StringBuilder();
            builder.append(this.numNodes + ":");
            builder.append('[');
            for (int count = 0; node != this.tail && count < 500; ++count) {
                if (count != 0) {
                    builder.append(",");
                }
                builder.append(node);
                node = node.prev;
            }
            if (node != this.tail) {
                builder.append("...");
            }
            builder.append(']');
            return builder.toString();
        }

        static class RecordNode {
            RecordNode next;
            RecordNode prev;
            RecordNumber recordNumber;

            private RecordNode(RecordNumber recordNumber) {
                this.recordNumber = recordNumber;
            }

            public String toString() {
                return this.recordNumber.toString();
            }
        }
    }
}

