/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client;

import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.client.ExecutableScorer;
import ghidra.features.bsim.query.client.ExecutableScorerSingle;
import ghidra.features.bsim.query.client.ScoreCaching;
import ghidra.features.bsim.query.client.tables.ExeTable;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.SignatureRecord;
import ghidra.features.bsim.query.description.VectorResult;
import ghidra.features.bsim.query.protocol.ExeSpecifier;
import ghidra.features.bsim.query.protocol.QueryExeInfo;
import ghidra.features.bsim.query.protocol.QueryInfo;
import ghidra.features.bsim.query.protocol.QueryName;
import ghidra.features.bsim.query.protocol.QueryNearestVector;
import ghidra.features.bsim.query.protocol.QueryVectorId;
import ghidra.features.bsim.query.protocol.QueryVectorMatch;
import ghidra.features.bsim.query.protocol.ResponseExe;
import ghidra.features.bsim.query.protocol.ResponseInfo;
import ghidra.features.bsim.query.protocol.ResponseName;
import ghidra.features.bsim.query.protocol.ResponseNearestVector;
import ghidra.features.bsim.query.protocol.ResponseVectorId;
import ghidra.features.bsim.query.protocol.ResponseVectorMatch;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class ExecutableComparison {
    private FunctionDatabase database;
    private ExecutableScorer scorer;
    private String singleMd5;
    private TreeSet<Long> baseIds;
    private TreeSet<Long> queriedIds;
    private LSHVectorFactory vectorFactory;
    private int hitCountThreshold;
    private int maxHitCount;
    private int exceedCount;
    private TaskMonitor monitor;

    public ExecutableComparison(FunctionDatabase database, int hitCountThreshold, TaskMonitor monitor) throws LSHException {
        this.database = database;
        this.singleMd5 = null;
        this.hitCountThreshold = hitCountThreshold;
        this.monitor = monitor;
        if (this.monitor == null) {
            this.monitor = TaskMonitor.DUMMY;
        }
        this.baseIds = null;
        this.queriedIds = null;
        DatabaseInformation info = this.pullConnectionInfo();
        this.scorer = new ExecutableScorer();
        this.scorer.transferSettings(info);
    }

    public ExecutableComparison(FunctionDatabase database, int hitCountThreshold, String md5, ScoreCaching cache, TaskMonitor monitor) throws LSHException {
        this.database = database;
        this.singleMd5 = md5;
        this.hitCountThreshold = hitCountThreshold;
        this.monitor = monitor;
        if (this.monitor == null) {
            this.monitor = TaskMonitor.DUMMY;
        }
        this.baseIds = null;
        this.queriedIds = null;
        DatabaseInformation info = this.pullConnectionInfo();
        this.scorer = new ExecutableScorerSingle(cache);
        this.scorer.transferSettings(info);
        this.addExecutable(this.singleMd5);
    }

    public int getMaxHitCount() {
        return this.maxHitCount;
    }

    public int getExceedCount() {
        return this.exceedCount;
    }

    public boolean isConfigured() {
        return this.scorer.simThreshold > 0.0;
    }

    private DatabaseInformation pullConnectionInfo() throws LSHException {
        if (!this.database.initialize()) {
            throw new LSHException("Unable to connect to server");
        }
        QueryInfo query = new QueryInfo();
        ResponseInfo response = (ResponseInfo)query.execute(this.database);
        if (response == null) {
            throw new LSHException(this.database.getLastError().message);
        }
        this.vectorFactory = this.database.getLSHVectorFactory();
        return response.info;
    }

    private ExecutableRecord lookupExecutable(String md5) throws LSHException {
        QueryName query = new QueryName();
        query.spec = new ExeSpecifier();
        query.spec.exemd5 = md5;
        query.maxfunc = 1;
        query.fillinCallgraph = false;
        query.fillinCategories = false;
        query.fillinSigs = false;
        ResponseName response = (ResponseName)query.execute(this.database);
        if (response == null) {
            throw new LSHException(this.database.getLastError().message);
        }
        if (response.manage.numExecutables() != 1) {
            throw new LSHException("Could not find executable");
        }
        return response.manage.getExecutableRecordSet().first();
    }

    private void pullVectorsForExe(ExeSpecifier exeSpec, Map<Long, Count> histogram) {
        QueryName queryName = new QueryName();
        queryName.spec = exeSpec;
        queryName.maxfunc = 100000;
        queryName.fillinCallgraph = false;
        queryName.fillinCategories = false;
        queryName.fillinSigs = false;
        ResponseName response = (ResponseName)queryName.execute(this.database);
        Iterator<FunctionDescription> iter = response.manage.listAllFunctions();
        if (histogram == null) {
            while (iter.hasNext()) {
                this.baseIds.add(iter.next().getVectorId());
            }
        } else {
            while (iter.hasNext()) {
                Long id = iter.next().getVectorId();
                Count count = histogram.computeIfAbsent(id, key -> new Count());
                ++count.value;
            }
        }
    }

    private void pullVectorsForScoringSet() throws CancelledException {
        this.baseIds = new TreeSet();
        this.queriedIds = new TreeSet();
        if (this.scorer instanceof ExecutableScorerSingle) {
            ExeSpecifier specifier = new ExeSpecifier();
            specifier.exemd5 = this.singleMd5;
            this.pullVectorsForExe(specifier, null);
            return;
        }
        this.monitor.setMessage("Accumulating vector ids");
        TreeSet<ExecutableRecord> recordSet = this.scorer.executableSet.getExecutableRecordSet();
        this.monitor.initialize((long)recordSet.size());
        ExeSpecifier specifier = new ExeSpecifier();
        for (ExecutableRecord exeRecord : recordSet) {
            specifier.exemd5 = exeRecord.getMd5();
            this.pullVectorsForExe(specifier, null);
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
        }
    }

    private QueryNearestVector buildVectorQuery(LSHVector vector, double threshold) throws LSHException {
        QueryNearestVector query = new QueryNearestVector();
        ExecutableRecord exeRecord = query.manage.newExecutableRecord("bbbbaaaabbbbaaaabbbbaaaabbbbaaaa", null, null, null, null, null, null, null);
        FunctionDescription function = query.manage.newFunctionDescription("tmp", 4096L, exeRecord);
        SignatureRecord signature = query.manage.newSignature(vector, 1);
        query.manage.attachSignature(function, signature);
        query.manage.transferSettings(this.scorer.executableSet);
        query.thresh = threshold;
        return query;
    }

    private VectorResult buildSeedVector(Long id) throws LSHException {
        QueryVectorId query = new QueryVectorId();
        query.vectorIds.add(id);
        ResponseVectorId response = (ResponseVectorId)query.execute(this.database);
        if (response == null || response.vectorResults.size() != 1) {
            throw new LSHException("Could not locate vector by id");
        }
        return response.vectorResults.get(0);
    }

    private VectorResult queryVectorForCluster(TreeMap<Long, VectorResult> workList, double threshold) throws LSHException {
        QueryNearestVector query;
        ResponseNearestVector response;
        Map.Entry<Long, VectorResult> entry = workList.pollFirstEntry();
        VectorResult currentVector = entry.getValue();
        this.baseIds.remove(entry.getKey());
        this.queriedIds.add(entry.getKey());
        if (currentVector == null) {
            currentVector = this.buildSeedVector(entry.getKey());
        }
        if ((response = (ResponseNearestVector)(query = this.buildVectorQuery(currentVector.vec, threshold)).execute(this.database)) == null || response.result.size() != 1) {
            throw new LSHException("Could not perform query on vector");
        }
        Iterator<VectorResult> iter = response.result.get(0).iterator();
        while (iter.hasNext()) {
            VectorResult vecResult = iter.next();
            Long curId = vecResult.vectorid;
            if (this.queriedIds.contains(curId)) continue;
            workList.put(curId, vecResult);
        }
        return currentVector;
    }

    private int buildCluster(List<VectorResult> cluster, double simThreshold, double sigThreshold) throws LSHException {
        TreeMap<Long, VectorResult> workList = new TreeMap<Long, VectorResult>();
        Long firstKey = this.baseIds.pollFirst();
        workList.put(firstKey, null);
        int hitCount = 0;
        while (!workList.isEmpty()) {
            VectorResult vectorInfo = this.queryVectorForCluster(workList, simThreshold);
            if (!(sigThreshold < this.vectorFactory.getSelfSignificance(vectorInfo.vec))) continue;
            cluster.add(vectorInfo);
            hitCount += vectorInfo.hitcount;
        }
        return hitCount;
    }

    private List<DescriptionManager> vectorToFunctions(List<VectorResult> cluster) throws LSHException {
        ArrayList<DescriptionManager> result = new ArrayList<DescriptionManager>(cluster.size());
        for (int i = 0; i < cluster.size(); ++i) {
            VectorResult vector = cluster.get(i);
            QueryVectorMatch query = new QueryVectorMatch();
            query.fillinCategories = false;
            query.max = vector.hitcount + 10;
            query.vectorIds.add(vector.vectorid);
            ResponseVectorMatch response = (ResponseVectorMatch)query.execute(this.database);
            if (response == null) {
                throw new LSHException(this.database.getLastError().message);
            }
            this.scorer.labelAndFilter(response.manage);
            result.add(response.manage);
        }
        return result;
    }

    public ExecutableScorer getScorer() {
        return this.scorer;
    }

    public void addExecutable(String md5) throws LSHException {
        ExecutableRecord exeRecord = this.lookupExecutable(md5);
        this.scorer.addExecutable(exeRecord);
    }

    public void addAllExecutables(int limit) throws LSHException {
        QueryExeInfo query = new QueryExeInfo(limit, null, null, null, null, ExeTable.ExeTableOrderColumn.MD5, false);
        ResponseExe responseExe = (ResponseExe)query.execute(this.database);
        if (responseExe == null) {
            throw new LSHException(this.database.getLastError().message);
        }
        for (ExecutableRecord exeRecord : responseExe.records) {
            this.scorer.addExecutable(exeRecord);
        }
    }

    public void performScoring() throws LSHException, CancelledException {
        this.maxHitCount = 0;
        this.exceedCount = 0;
        this.scorer.populateExecutableIndex();
        if (this.singleMd5 != null) {
            this.scorer.setSingleExecutable(this.singleMd5);
        }
        this.pullVectorsForScoringSet();
        this.scorer.initializeScores();
        this.monitor.setMessage("Processing similar functions");
        int maxSize = this.baseIds.size();
        this.monitor.initialize((long)maxSize);
        if (this.scorer.simThreshold < 0.0) {
            throw new LSHException("No thresholds have been established");
        }
        while (!this.baseIds.isEmpty()) {
            ArrayList<VectorResult> vectors = new ArrayList<VectorResult>();
            int hitcount = this.buildCluster(vectors, this.scorer.simThreshold, this.scorer.sigThreshold);
            if (hitcount == 0) continue;
            if (hitcount > this.maxHitCount) {
                this.maxHitCount = hitcount;
            }
            if (!this.scorer.checkPreliminaryPairThreshold(hitcount, this.hitCountThreshold)) {
                ++this.exceedCount;
                continue;
            }
            List<DescriptionManager> vec2Functions = this.vectorToFunctions(vectors);
            if (!this.scorer.scoreCluster(this.vectorFactory, vec2Functions, vectors, hitcount, this.hitCountThreshold)) {
                ++this.exceedCount;
                continue;
            }
            this.monitor.checkCancelled();
            this.monitor.setProgress((long)(maxSize - this.baseIds.size()));
        }
        this.baseIds = null;
        this.queriedIds = null;
    }

    public void resetThresholds(double simThreshold, double sigThreshold) throws LSHException {
        this.scorer.resetStorage(simThreshold, sigThreshold);
    }

    public void fillinSelfScores() throws LSHException, CancelledException {
        if (!(this.scorer instanceof ExecutableScorerSingle)) {
            return;
        }
        ExecutableScorerSingle singleScorer = (ExecutableScorerSingle)this.scorer;
        ArrayList<ExecutableRecord> missing = new ArrayList<ExecutableRecord>();
        singleScorer.prefetchSelfScores(missing);
        int size = missing.size();
        if (size == 0) {
            return;
        }
        if (size == 1 && ((ExecutableRecord)missing.get(0)).getMd5().equals(this.singleMd5)) {
            return;
        }
        double sigThreshold = singleScorer.getSigThreshold();
        this.monitor.setMessage("Generating self-significance scores");
        this.monitor.initialize((long)size);
        Iterator iter = missing.iterator();
        ExeSpecifier exeSpec = new ExeSpecifier();
        while (iter.hasNext()) {
            ExecutableRecord exeRec = (ExecutableRecord)iter.next();
            if (exeRec.getMd5().equals(this.singleMd5)) continue;
            TreeMap<Long, Count> histogram = new TreeMap<Long, Count>();
            exeSpec.exemd5 = exeRec.getMd5();
            this.pullVectorsForExe(exeSpec, histogram);
            double score = 0.0;
            for (Map.Entry<Long, Count> entry : histogram.entrySet()) {
                VectorResult vecResult = this.buildSeedVector(entry.getKey());
                double significance = this.vectorFactory.getSelfSignificance(vecResult.vec);
                if (significance < sigThreshold) continue;
                score += significance * (double)entry.getValue().value;
            }
            this.scorer.commitSelfScore(exeRec.getMd5(), (float)score);
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
        }
    }

    public static class Count {
        public int value = 0;
    }
}

