/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.function.FunctionAdapterV0;
import ghidra.program.database.function.FunctionAdapterV1;
import ghidra.program.database.function.FunctionAdapterV2;
import ghidra.program.database.function.FunctionAdapterV3;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class FunctionAdapter {
    static final String FUNCTIONS_TABLE_NAME = "Function Data";
    static final int CURRENT_VERSION = 3;
    static final int RETURN_DATA_TYPE_ID_COL = 0;
    static final int STACK_PURGE_COL = 1;
    static final int STACK_RETURN_OFFSET_COL = 2;
    static final int STACK_LOCAL_SIZE_COL = 3;
    static final int FUNCTION_FLAGS_COL = 4;
    static final int CALLING_CONVENTION_ID_COL = 5;
    static final int RETURN_STORAGE_COL = 6;
    static final byte FUNCTION_VARARG_FLAG = 1;
    static final byte FUNCTION_INLINE_FLAG = 2;
    static final byte FUNCTION_NO_RETURN_FLAG = 4;
    static final byte FUNCTION_CUSTOM_PARAM_STORAGE_FLAG = 8;
    static final byte FUNCTION_SIGNATURE_SOURCE = 112;
    static final int FUNCTION_SIGNATURE_SOURCE_SHIFT = 4;
    private static final int MAX_SOURCE_VALUE = 7;
    static final Schema FUNCTION_SCHEMA = new Schema(3, "ID", new Field[]{LongField.INSTANCE, IntField.INSTANCE, IntField.INSTANCE, IntField.INSTANCE, ByteField.INSTANCE, ByteField.INSTANCE, StringField.INSTANCE}, new String[]{"Return DataType ID", "StackPurge", "StackReturnOffset", "StackLocalSize", "Flags", "Calling Convention ID", "Return Storage"});
    protected AddressMap addrMap;

    static FunctionAdapter getAdapter(DBHandle handle, OpenMode openMode, AddressMap map, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == OpenMode.CREATE) {
            return new FunctionAdapterV3(handle, map, true);
        }
        try {
            FunctionAdapterV3 adapter = new FunctionAdapterV3(handle, map, false);
            if (map.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            FunctionAdapter adapter = FunctionAdapter.findReadOnlyAdapter(handle, map);
            if (openMode == OpenMode.UPGRADE) {
                adapter = FunctionAdapter.upgrade(handle, adapter, map, monitor);
            }
            return adapter;
        }
    }

    static int getVersion(DBHandle handle, AddressMap map, TaskMonitor monitor) throws VersionException, IOException {
        FunctionAdapter oldAdapter = FunctionAdapter.findReadOnlyAdapter(handle, map);
        return oldAdapter.getVersion();
    }

    FunctionAdapter(AddressMap map) {
        this.addrMap = map;
    }

    static byte getSignatureSourceFlagBits(SourceType signatureSource) {
        int sourceTypeId = signatureSource.getStorageId();
        if (sourceTypeId > 7) {
            throw new RuntimeException("Unsupported SourceType storage ID: " + sourceTypeId);
        }
        return (byte)(sourceTypeId << 4);
    }

    static FunctionAdapter findReadOnlyAdapter(DBHandle handle, AddressMap map) throws VersionException, IOException {
        try {
            return new FunctionAdapterV3(handle, map.getOldAddressMap(), false);
        }
        catch (VersionException versionException) {
            try {
                return new FunctionAdapterV2(handle, map.getOldAddressMap());
            }
            catch (VersionException versionException2) {
                try {
                    return new FunctionAdapterV1(handle, map.getOldAddressMap());
                }
                catch (VersionException versionException3) {
                    return new FunctionAdapterV0(handle, map.getOldAddressMap());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FunctionAdapter upgrade(DBHandle handle, FunctionAdapter oldAdapter, AddressMap map, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            monitor.setMessage("Upgrading Functions...");
            monitor.initialize((long)(oldAdapter.getRecordCount() * 2));
            int count = 0;
            FunctionAdapterV3 tmpAdapter = new FunctionAdapterV3(tmpHandle, map, true);
            RecordIterator it = oldAdapter.iterateFunctionRecords();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((FunctionAdapter)tmpAdapter).updateFunctionRecord(rec);
                monitor.setProgress((long)(++count));
            }
            oldAdapter.deleteTable(handle);
            FunctionAdapterV3 newAdapter = new FunctionAdapterV3(handle, map, true);
            it = ((FunctionAdapter)tmpAdapter).iterateFunctionRecords();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((FunctionAdapter)newAdapter).updateFunctionRecord(rec);
                monitor.setProgress((long)(++count));
            }
            FunctionAdapterV3 functionAdapterV3 = newAdapter;
            return functionAdapterV3;
        }
    }

    abstract RecordIterator iterateFunctionRecords() throws IOException;

    protected abstract void deleteTable(DBHandle var1) throws IOException;

    abstract int getVersion();

    abstract int getRecordCount();

    abstract void removeFunctionRecord(long var1) throws IOException;

    abstract DBRecord getFunctionRecord(long var1) throws IOException;

    abstract void updateFunctionRecord(DBRecord var1) throws IOException;

    abstract DBRecord createFunctionRecord(long var1, long var3) throws IOException;

    abstract DBRecord translateRecord(DBRecord var1);

    class TranslatedRecordIterator
    implements RecordIterator {
        private RecordIterator it;

        TranslatedRecordIterator(RecordIterator it) {
            this.it = it;
        }

        public boolean hasNext() throws IOException {
            return this.it.hasNext();
        }

        public boolean hasPrevious() throws IOException {
            return this.it.hasPrevious();
        }

        public DBRecord next() throws IOException {
            return FunctionAdapter.this.translateRecord(this.it.next());
        }

        public DBRecord previous() throws IOException {
            return FunctionAdapter.this.translateRecord(this.it.previous());
        }

        public boolean delete() throws IOException {
            return false;
        }
    }
}

