/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.map;

import db.DBLongIterator;
import db.Table;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.KeyRange;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;

public class AddressKeyIterator
implements DBLongIterator {
    public static final AddressKeyIterator EMPTY_ITERATOR = new AddressKeyIterator();
    private Table table;
    private List<KeyRange> keyRangeList;
    private DBLongIterator it;
    private int keyRangeIndex = -1;

    private AddressKeyIterator() {
    }

    public AddressKeyIterator(Table table, AddressMap addrMap, boolean before) throws IOException {
        this(table, addrMap, false, null, null, before);
    }

    public AddressKeyIterator(Table table, AddressMap addrMap, Address startAddr, boolean before) throws IOException {
        this(table, addrMap, false, null, startAddr, before);
    }

    public AddressKeyIterator(Table table, AddressMap addrMap, Address minAddr, Address maxAddr, Address startAddr, boolean before) throws IOException {
        this(table, addrMap, false, addrMap.getAddressFactory().getAddressSet(minAddr, maxAddr), startAddr, before);
    }

    public AddressKeyIterator(Table table, AddressMap addrMap, AddressSetView set, Address startAddr, boolean before) throws IOException {
        this(table, addrMap, false, set, startAddr, before);
    }

    AddressKeyIterator(Table table, AddressMap addrMap, boolean absolute, AddressSetView set, Address startAddr, boolean before) throws IOException {
        this.table = table;
        this.keyRangeList = addrMap.getKeyRanges(set, absolute, false);
        if (this.keyRangeList.size() == 0) {
            return;
        }
        this.keyRangeIndex = startAddr == null ? (before ? -1 : -this.keyRangeList.size() - 1) : addrMap.findKeyRange(this.keyRangeList, startAddr);
        if (this.keyRangeIndex >= 0) {
            KeyRange keyRange = this.keyRangeList.get(this.keyRangeIndex);
            long key = absolute ? addrMap.getAbsoluteEncoding(startAddr, false) : addrMap.getKey(startAddr, false);
            this.it = table.longKeyIterator(keyRange.minKey, keyRange.maxKey, key);
            if (table.hasRecord(key)) {
                if (before) {
                    this.it.previous();
                } else {
                    this.it.next();
                }
            }
        } else {
            this.keyRangeIndex = -this.keyRangeIndex - 1;
            if (this.keyRangeIndex < this.keyRangeList.size()) {
                KeyRange keyRange = this.keyRangeList.get(this.keyRangeIndex);
                this.it = table.longKeyIterator(keyRange.minKey, keyRange.maxKey, keyRange.minKey);
                if (this.hasPrevious()) {
                    this.it.previous();
                }
            } else {
                --this.keyRangeIndex;
                KeyRange keyRange = this.keyRangeList.get(this.keyRangeIndex);
                this.it = table.longKeyIterator(keyRange.minKey, keyRange.maxKey, keyRange.maxKey);
                if (this.hasNext()) {
                    this.it.next();
                }
            }
        }
    }

    public boolean hasNext() throws IOException {
        if (this.it == null) {
            return false;
        }
        if (!this.it.hasNext()) {
            while (this.keyRangeIndex < this.keyRangeList.size() - 1) {
                KeyRange keyRange = this.keyRangeList.get(++this.keyRangeIndex);
                this.it = this.table.longKeyIterator(keyRange.minKey, keyRange.maxKey, keyRange.minKey);
                if (this.it.hasPrevious()) {
                    this.it.previous();
                }
                if (!this.it.hasNext()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean hasPrevious() throws IOException {
        if (this.it == null) {
            return false;
        }
        if (!this.it.hasPrevious()) {
            while (this.keyRangeIndex > 0) {
                KeyRange keyRange = this.keyRangeList.get(--this.keyRangeIndex);
                this.it = this.table.longKeyIterator(keyRange.minKey, keyRange.maxKey, keyRange.maxKey);
                if (this.it.hasNext()) {
                    this.it.next();
                }
                if (!this.it.hasPrevious()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public long next() throws IOException {
        if (this.hasNext()) {
            return this.it.next();
        }
        throw new NoSuchElementException();
    }

    public long previous() throws IOException {
        if (this.hasPrevious()) {
            return this.it.previous();
        }
        throw new NoSuchElementException();
    }

    public boolean delete() throws IOException {
        if (this.it != null) {
            return this.it.delete();
        }
        return false;
    }
}

