/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.BlockGraph;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeOp;
import java.io.IOException;

public class BlockCondition
extends BlockGraph {
    private int opcode;

    public BlockCondition() {
        this.blocktype = 7;
        this.opcode = 39;
    }

    public int getOpcode() {
        return this.opcode;
    }

    @Override
    protected void encodeHeader(Encoder encoder) throws IOException {
        super.encodeHeader(encoder);
        String opcodename = PcodeOp.getMnemonic(this.opcode);
        encoder.writeString(AttributeId.ATTRIB_OPCODE, opcodename);
    }

    @Override
    protected void decodeHeader(Decoder decoder) throws DecoderException {
        super.decodeHeader(decoder);
        String opcodename = decoder.readString(AttributeId.ATTRIB_OPCODE);
        try {
            this.opcode = PcodeOp.getOpcode(opcodename);
        }
        catch (UnknownInstructionException e) {
            this.opcode = 39;
        }
    }
}

