/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;
import generic.stl.Pair;
import generic.stl.RedBlackNode;
import generic.stl.RedBlackTree;

public class MapIteratorSTL<K, V>
implements IteratorSTL<Pair<K, V>> {
    protected RedBlackTree<K, V> tree;
    protected RedBlackNode<K, V> node;
    protected boolean erased;

    MapIteratorSTL(RedBlackTree<K, V> tree, RedBlackNode<K, V> node, boolean erased) {
        this.tree = tree;
        this.node = node;
        this.erased = erased;
    }

    MapIteratorSTL(RedBlackTree<K, V> tree, RedBlackNode<K, V> node) {
        this.tree = tree;
        this.node = node;
    }

    @Override
    public void assign(IteratorSTL<Pair<K, V>> otherIterator) {
        MapIteratorSTL other = (MapIteratorSTL)otherIterator;
        this.tree = other.tree;
        this.node = other.node;
        this.erased = other.erased;
    }

    @Override
    public IteratorSTL<Pair<K, V>> decrement() {
        if (this.node == null && this.tree.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        this.node = this.node == null ? this.tree.getLast() : this.node.getPredecessor();
        this.erased = false;
        return this;
    }

    @Override
    public Pair<K, V> get() {
        if (this.erased) {
            throw new IndexOutOfBoundsException("element erased");
        }
        if (this.node == null) {
            throw new IndexOutOfBoundsException();
        }
        return new Pair<K, V>(this.node.getKey(), this.node.getValue());
    }

    @Override
    public IteratorSTL<Pair<K, V>> increment() {
        if (!this.erased && this.node == null) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.erased) {
            this.node = this.node.getSuccessor();
        }
        this.erased = false;
        return this;
    }

    @Override
    public void insert(Pair<K, V> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBegin() {
        if (this.erased) {
            throw new RuntimeException("Iterater in invalid state");
        }
        return this.node == this.tree.getFirst();
    }

    @Override
    public boolean isEnd() {
        if (this.erased) {
            throw new RuntimeException("Iterater in invalid state");
        }
        return this.node == null;
    }

    @Override
    public void set(Pair<K, V> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IteratorSTL<Pair<K, V>> copy() {
        return new MapIteratorSTL<K, V>(this.tree, this.node);
    }

    @Override
    public IteratorSTL<Pair<K, V>> decrement(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IteratorSTL<Pair<K, V>> increment(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MapIteratorSTL other = (MapIteratorSTL)obj;
        return this.tree == other.tree && this.node == other.node && this.erased == other.erased;
    }
}

