/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.adapter.writers.CIFWriter;
import org.jmol.modelset.Atom;
import org.jmol.util.Vibration;

public class FSG2SCIFConverter
extends CIFWriter {
    private Map<String, Object> scifInfo;
    private int[] spinIndex;
    private static final V3 v0 = V3.new3(3.14159f, 2.71828f, 1.4142f);
    private static final String[] headerKeys = new String[]{"_space_group_spin.transform_spinframe_P_abc", "_space_group_spin.collinear_direction", "_space_group_spin.coplanar_perp_uvw", "_space_group_spin.rotation_axis_cartn", "_space_group_spin.rotation_angle", "_space_group_spin.number_SpSG_Chen", "_space_group_spin.name_SpSG_Chen"};
    private static final String operationKeys = "\nloop_\n_space_group_symop_spin_operation.id\n_space_group_symop_spin_operation.xyzt\n_space_group_symop_spin_operation.uvw_id\n";
    private static final String latticeKeys = "\nloop_\n_space_group_symop_spin_lattice.id\n_space_group_symop_spin_lattice.xyzt\n_space_group_symop_spin_lattice.uvw_id\n";
    private static final String upartKeys = "\nloop_\n_space_group_symop_spin_Upart.id\n_space_group_symop_spin_Upart.time_reversal\n_space_group_symop_spin_Upart.uvw\n";
    private static final String momentKeys = "\nloop_\n_atom_site_spin_moment.label\n_atom_site_spin_moment.axis_u\n_atom_site_spin_moment.axis_v\n_atom_site_spin_moment.axis_w\n_atom_site_spin_moment.symmform_uvw\n_atom_site_spin_moment.magnitude\n";

    @Override
    protected void prepareAtomSet(BS bs) {
        super.prepareAtomSet(bs);
        this.modelInfo = (Map)this.data[0];
        this.scifInfo = (Map)this.data[1];
    }

    @Override
    protected void writeHeader(SB sb) {
        V3 axis = null;
        float angle = 0.0f;
        M3 m3 = (M3)this.modelInfo.get("spinRotationMatrixApplied");
        if (m3 != null) {
            Quat q = Quat.newM(m3);
            axis = q.getNormalDirected(v0);
            angle = q.getThetaDirectedV(v0);
            if (Math.abs(angle) < 1.0f) {
                axis = null;
            }
        }
        for (int i = 0; i < headerKeys.length; ++i) {
            String s;
            String type = (String)this.scifInfo.get("configuration");
            switch (i) {
                case 0: {
                    s = (String)this.scifInfo.get("spinFrame");
                    break;
                }
                case 1: {
                    s = type.equals("Collinear") ? "1,0,0" : ".";
                    break;
                }
                case 2: {
                    s = type.equals("Coplanar") ? "0,0,1" : ".";
                    break;
                }
                case 3: {
                    s = axis == null ? "?" : "[ " + axis.x + " " + axis.y + " " + axis.z + " ]";
                    break;
                }
                case 4: {
                    s = angle == 0.0f ? "?" : this.clean(angle);
                    break;
                }
                case 5: {
                    s = (String)this.scifInfo.get("fsgID");
                    break;
                }
                case 6: {
                    s = "\n;\n" + this.scifInfo.get("simpleName") + "\n;\n";
                    break;
                }
                default: {
                    s = "??";
                }
            }
            FSG2SCIFConverter.appendField(sb, headerKeys[i], 45);
            sb.append(s).append("\n");
        }
    }

    @Override
    protected void writeOperations(SB sb) {
        int[] refsOp = (int[])this.scifInfo.get("G0_operationURefs");
        int[] refsLat = (int[])this.scifInfo.get("G0_spinLatticeURefs");
        BS bsUparts = this.getReferences(refsOp, refsLat);
        int[] timeRev = (int[])this.scifInfo.get("SCIF_spinListTR");
        this.addOps(sb, operationKeys, "G0_operations", refsOp, timeRev);
        this.addOps(sb, latticeKeys, "G0_spinLattice", refsLat, timeRev);
        sb.append(upartKeys);
        Lst uparts = (Lst)this.scifInfo.get("SCIF_spinList");
        int i = bsUparts.nextSetBit(0);
        while (i >= 0) {
            FSG2SCIFConverter.appendField(sb, "" + this.spinIndex[i], 3);
            FSG2SCIFConverter.appendField(sb, "" + timeRev[i], 3);
            FSG2SCIFConverter.appendField(sb, (String)uparts.get(i), 30);
            sb.append("\n");
            i = bsUparts.nextSetBit(i + 1);
        }
    }

    private BS getReferences(int[] refsOp, int[] refsLat) {
        BS bs = new BS();
        int i = refsOp.length;
        while (--i >= 0) {
            bs.set(refsOp[i]);
        }
        if (refsLat != null) {
            i = refsLat.length;
            while (--i >= 0) {
                bs.set(refsLat[i]);
            }
        }
        this.spinIndex = new int[bs.length()];
        int pt = 0;
        int i2 = bs.nextSetBit(0);
        while (i2 >= 0) {
            this.spinIndex[i2] = ++pt;
            i2 = bs.nextSetBit(i2 + 1);
        }
        return bs;
    }

    private static String timeRevValue(int t) {
        return t < 0 ? "-1" : "+1";
    }

    private void addOps(SB sb, String loopKeys, String opsKey, int[] refs, int[] timeReversal) {
        Lst ops = (Lst)this.scifInfo.get(opsKey);
        if (ops == null) {
            return;
        }
        sb.append(loopKeys);
        int n = ops.size();
        for (int i = 0; i < n; ++i) {
            String xyz = ((String)ops.get(i)).substring(0, ((String)ops.get(i)).indexOf(40));
            FSG2SCIFConverter.appendField(sb, "" + (i + 1), 3);
            FSG2SCIFConverter.appendField(sb, xyz + "," + FSG2SCIFConverter.timeRevValue(timeReversal[refs[i]]), 30);
            FSG2SCIFConverter.appendField(sb, "" + this.spinIndex[refs[i]], 3);
            sb.append("\n");
        }
    }

    @Override
    protected int writeAtomSite(SB sb) {
        int natoms = super.writeAtomSite(sb);
        sb.append(momentKeys);
        int i = this.bsOut.nextSetBit(0);
        int p = 0;
        while (i >= 0) {
            Atom a = this.atoms[i];
            String label = this.atomLabels[p++];
            Vibration m = a.getVibrationVector();
            if (m != null && m.magMoment != 0.0f) {
                FSG2SCIFConverter.appendField(sb, label, 5);
                V3 v = m.v0 == null ? m : m.v0;
                this.append3(sb, v);
                sb.append(" ?");
                sb.append(" ").append(this.clean(v.length()));
                sb.append("\n");
            }
            i = this.bsOut.nextSetBit(i + 1);
        }
        this.jmol_atoms = null;
        return natoms;
    }
}

