/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene40.blocktree;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.backward_codecs.lucene40.blocktree.CompressionAlgorithm;
import org.apache.lucene.backward_codecs.lucene40.blocktree.IntersectTermsEnum;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.FST;

final class IntersectTermsEnumFrame {
    final int ord;
    long fp;
    long fpOrig;
    long fpEnd;
    long lastSubFP;
    int state;
    int lastState;
    int metaDataUpto;
    byte[] suffixBytes = new byte[128];
    final ByteArrayDataInput suffixesReader = new ByteArrayDataInput();
    byte[] suffixLengthBytes;
    final ByteArrayDataInput suffixLengthsReader;
    byte[] statBytes = new byte[64];
    int statsSingletonRunLength = 0;
    final ByteArrayDataInput statsReader = new ByteArrayDataInput();
    byte[] floorData = new byte[32];
    final ByteArrayDataInput floorDataReader = new ByteArrayDataInput();
    int prefix;
    int entCount;
    int nextEnt;
    boolean isLastInFloor;
    boolean isLeafBlock;
    int numFollowFloorBlocks;
    int nextFloorLabel;
    final Transition transition = new Transition();
    int transitionIndex;
    int transitionCount;
    FST.Arc<BytesRef> arc;
    final BlockTermState termState;
    byte[] bytes = new byte[32];
    final ByteArrayDataInput bytesReader = new ByteArrayDataInput();
    BytesRef outputPrefix;
    int startBytePos;
    int suffix;
    private final IntersectTermsEnum ite;
    private final int version;

    public IntersectTermsEnumFrame(IntersectTermsEnum ite, int ord) throws IOException {
        this.ite = ite;
        this.ord = ord;
        this.termState = ite.fr.parent.postingsReader.newTermState();
        this.termState.totalTermFreq = -1L;
        this.version = ite.fr.parent.version;
        if (this.version >= 5) {
            this.suffixLengthBytes = new byte[32];
            this.suffixLengthsReader = new ByteArrayDataInput();
        } else {
            this.suffixLengthBytes = null;
            this.suffixLengthsReader = this.suffixesReader;
        }
    }

    void loadNextFloorBlock() throws IOException {
        assert (this.numFollowFloorBlocks > 0) : "nextFloorLabel=" + this.nextFloorLabel;
        do {
            this.fp = this.fpOrig + (this.floorDataReader.readVLong() >>> 1);
            --this.numFollowFloorBlocks;
            this.nextFloorLabel = this.numFollowFloorBlocks != 0 ? this.floorDataReader.readByte() & 0xFF : 256;
        } while (this.numFollowFloorBlocks != 0 && this.nextFloorLabel <= this.transition.min);
        this.load(null);
    }

    public void setState(int state) {
        this.state = state;
        this.transitionIndex = 0;
        this.transitionCount = this.ite.automaton.getNumTransitions(state);
        if (this.transitionCount != 0) {
            this.ite.automaton.initTransition(state, this.transition);
            this.ite.automaton.getNextTransition(this.transition);
        } else {
            this.transition.min = -1;
            this.transition.max = -1;
        }
    }

    void load(BytesRef frameIndexData) throws IOException {
        if (frameIndexData != null) {
            this.floorDataReader.reset(frameIndexData.bytes, frameIndexData.offset, frameIndexData.length);
            long code = this.floorDataReader.readVLong();
            if ((code & 1L) != 0L) {
                this.numFollowFloorBlocks = this.floorDataReader.readVInt();
                this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
                if (!this.ite.runAutomaton.isAccept(this.state) && this.transitionCount != 0) {
                    assert (this.transitionIndex == 0) : "transitionIndex=" + this.transitionIndex;
                    while (this.numFollowFloorBlocks != 0 && this.nextFloorLabel <= this.transition.min) {
                        this.fp = this.fpOrig + (this.floorDataReader.readVLong() >>> 1);
                        --this.numFollowFloorBlocks;
                        if (this.numFollowFloorBlocks != 0) {
                            this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
                            continue;
                        }
                        this.nextFloorLabel = 256;
                    }
                }
            }
        }
        this.ite.in.seek(this.fp);
        int code = this.ite.in.readVInt();
        this.entCount = code >>> 1;
        assert (this.entCount > 0);
        boolean bl = this.isLastInFloor = (code & 1) != 0;
        if (this.version >= 5) {
            boolean allEqual;
            CompressionAlgorithm compressionAlg;
            long codeL = this.ite.in.readVLong();
            this.isLeafBlock = (codeL & 4L) != 0L;
            int numSuffixBytes = (int)(codeL >>> 3);
            if (this.suffixBytes.length < numSuffixBytes) {
                this.suffixBytes = new byte[ArrayUtil.oversize((int)numSuffixBytes, (int)1)];
            }
            try {
                compressionAlg = CompressionAlgorithm.byCode((int)codeL & 3);
            }
            catch (IllegalArgumentException e) {
                throw new CorruptIndexException(e.getMessage(), (DataInput)this.ite.in, (Throwable)e);
            }
            compressionAlg.read((DataInput)this.ite.in, this.suffixBytes, numSuffixBytes);
            this.suffixesReader.reset(this.suffixBytes, 0, numSuffixBytes);
            int numSuffixLengthBytes = this.ite.in.readVInt();
            boolean bl2 = allEqual = (numSuffixLengthBytes & 1) != 0;
            if (this.suffixLengthBytes.length < (numSuffixLengthBytes >>>= 1)) {
                this.suffixLengthBytes = new byte[ArrayUtil.oversize((int)numSuffixLengthBytes, (int)1)];
            }
            if (allEqual) {
                Arrays.fill(this.suffixLengthBytes, 0, numSuffixLengthBytes, this.ite.in.readByte());
            } else {
                this.ite.in.readBytes(this.suffixLengthBytes, 0, numSuffixLengthBytes);
            }
            this.suffixLengthsReader.reset(this.suffixLengthBytes, 0, numSuffixLengthBytes);
        } else {
            code = this.ite.in.readVInt();
            this.isLeafBlock = (code & 1) != 0;
            int numBytes = code >>> 1;
            if (this.suffixBytes.length < numBytes) {
                this.suffixBytes = new byte[ArrayUtil.oversize((int)numBytes, (int)1)];
            }
            this.ite.in.readBytes(this.suffixBytes, 0, numBytes);
            this.suffixesReader.reset(this.suffixBytes, 0, numBytes);
        }
        int numBytes = this.ite.in.readVInt();
        if (this.statBytes.length < numBytes) {
            this.statBytes = new byte[ArrayUtil.oversize((int)numBytes, (int)1)];
        }
        this.ite.in.readBytes(this.statBytes, 0, numBytes);
        this.statsReader.reset(this.statBytes, 0, numBytes);
        this.statsSingletonRunLength = 0;
        this.metaDataUpto = 0;
        this.termState.termBlockOrd = 0;
        this.nextEnt = 0;
        numBytes = this.ite.in.readVInt();
        if (this.bytes.length < numBytes) {
            this.bytes = new byte[ArrayUtil.oversize((int)numBytes, (int)1)];
        }
        this.ite.in.readBytes(this.bytes, 0, numBytes);
        this.bytesReader.reset(this.bytes, 0, numBytes);
        if (!this.isLastInFloor) {
            this.fpEnd = this.ite.in.getFilePointer();
        }
    }

    public boolean next() {
        if (this.isLeafBlock) {
            this.nextLeaf();
            return false;
        }
        return this.nextNonLeaf();
    }

    public void nextLeaf() {
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
        ++this.nextEnt;
        this.suffix = this.suffixLengthsReader.readVInt();
        this.startBytePos = this.suffixesReader.getPosition();
        this.suffixesReader.skipBytes((long)this.suffix);
    }

    public boolean nextNonLeaf() {
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
        ++this.nextEnt;
        int code = this.suffixLengthsReader.readVInt();
        this.suffix = code >>> 1;
        this.startBytePos = this.suffixesReader.getPosition();
        this.suffixesReader.skipBytes((long)this.suffix);
        if ((code & 1) == 0) {
            ++this.termState.termBlockOrd;
            return false;
        }
        this.lastSubFP = this.fp - this.suffixLengthsReader.readVLong();
        return true;
    }

    public int getTermBlockOrd() {
        return this.isLeafBlock ? this.nextEnt : this.termState.termBlockOrd;
    }

    public void decodeMetaData() throws IOException {
        boolean absolute;
        int limit = this.getTermBlockOrd();
        boolean bl = absolute = this.metaDataUpto == 0;
        assert (limit > 0);
        while (this.metaDataUpto < limit) {
            if (this.version >= 5) {
                if (this.statsSingletonRunLength > 0) {
                    this.termState.docFreq = 1;
                    this.termState.totalTermFreq = 1L;
                    --this.statsSingletonRunLength;
                } else {
                    int token = this.statsReader.readVInt();
                    if (this.version >= 5 && (token & 1) == 1) {
                        this.termState.docFreq = 1;
                        this.termState.totalTermFreq = 1L;
                        this.statsSingletonRunLength = token >>> 1;
                    } else {
                        this.termState.docFreq = token >>> 1;
                        this.termState.totalTermFreq = this.ite.fr.fieldInfo.getIndexOptions() == IndexOptions.DOCS ? (long)this.termState.docFreq : (long)this.termState.docFreq + this.statsReader.readVLong();
                    }
                }
            } else {
                this.termState.docFreq = this.statsReader.readVInt();
                this.termState.totalTermFreq = this.ite.fr.fieldInfo.getIndexOptions() == IndexOptions.DOCS ? (long)this.termState.docFreq : (long)this.termState.docFreq + this.statsReader.readVLong();
            }
            this.ite.fr.parent.postingsReader.decodeTerm((DataInput)this.bytesReader, this.ite.fr.fieldInfo, this.termState, absolute);
            ++this.metaDataUpto;
            absolute = false;
        }
        this.termState.termBlockOrd = this.metaDataUpto;
    }
}

