/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.store;

import java.io.IOException;
import org.apache.lucene.store.FilterIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;

final class EndiannessReverserIndexInput
extends FilterIndexInput {
    EndiannessReverserIndexInput(IndexInput in) {
        super("Endianness reverser Index Input wrapper", in);
    }

    public short readShort() throws IOException {
        return Short.reverseBytes(this.in.readShort());
    }

    public int readInt() throws IOException {
        return Integer.reverseBytes(this.in.readInt());
    }

    public long readLong() throws IOException {
        return Long.reverseBytes(this.in.readLong());
    }

    public void readLongs(long[] dst, int offset, int length) throws IOException {
        this.in.readLongs(dst, offset, length);
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = Long.reverseBytes(dst[offset + i]);
        }
    }

    public void readInts(int[] dst, int offset, int length) throws IOException {
        this.in.readInts(dst, offset, length);
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = Integer.reverseBytes(dst[offset + i]);
        }
    }

    public void readFloats(float[] dst, int offset, int length) throws IOException {
        this.in.readFloats(dst, offset, length);
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(dst[offset + i])));
        }
    }

    public IndexInput clone() {
        return new EndiannessReverserIndexInput(this.in.clone());
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        return new EndiannessReverserIndexInput(this.in.slice(sliceDescription, offset, length));
    }

    public RandomAccessInput randomAccessSlice(long offset, long length) throws IOException {
        return new EndiannessReverserRandomAccessInput(this.in.randomAccessSlice(offset, length));
    }

    public static class EndiannessReverserRandomAccessInput
    implements RandomAccessInput {
        private final RandomAccessInput in;

        public EndiannessReverserRandomAccessInput(RandomAccessInput in) {
            this.in = in;
        }

        public long length() {
            return this.in.length();
        }

        public byte readByte(long pos) throws IOException {
            return this.in.readByte(pos);
        }

        public short readShort(long pos) throws IOException {
            return Short.reverseBytes(this.in.readShort(pos));
        }

        public int readInt(long pos) throws IOException {
            return Integer.reverseBytes(this.in.readInt(pos));
        }

        public long readLong(long pos) throws IOException {
            return Long.reverseBytes(this.in.readLong(pos));
        }
    }
}

